/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.widget;

import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.Property;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.soapkit.common.SoapkitUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.editors.CustomEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

public class SoapkitConfigWidget
extends CustomEditor {
    private WsdlModel wsdlModel;
    private StyledText wsdlLocationText;
    private Combo serviceCombo;
    private Combo portCombo;
    private Button pickFileButton;
    private static final String SOAPKIT_CONFIG_NAME = "api-config";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String WSDL_ATTRIBUTE = "wsdlLocation";
    private static final String SERVICE_ATTRIBUTE = "service";
    private static final String PORT_ATTRIBUTE = "port";

    public SoapkitConfigWidget(AttributesPropertyPage parentPage, AttributeHelper helper) {
        super(parentPage, helper);
    }

    public void refreshEditor(String newValue, boolean shouldNotifyObservers) {
    }

    protected Control createControl(AttributesPropertyPage parentPage) {
        IProject project = parentPage.getMuleProject().getJavaProject().getProject();
        Group parentComposite = this.getGroup(parentPage);
        GridLayoutFactory.swtDefaults().numColumns(3).equalWidth(false).applyTo((Composite)parentComposite);
        GridDataFactory.fillDefaults().align(4, 4).grab(true, true).applyTo((Control)parentComposite);
        this.initWsdlLocationWidget((Composite)parentComposite, project);
        this.serviceCombo = this.createSimpleComboBox((Composite)parentComposite, "Service:", false);
        this.serviceCombo.addModifyListener(this.serviceComboModifyListener());
        this.portCombo = this.createSimpleComboBox((Composite)parentComposite, "Port:", false);
        return parentComposite;
    }

    public void loadFrom(IMessageFlowNode node, PropertyCollectionMap props) {
        PropertyCollection properties = node.getPropertiesForEdit(node.getElement());
        this.wsdlLocationText.setText(this.getPropertyValue(properties, WSDL_ATTRIBUTE));
        this.serviceCombo.setText(this.getPropertyValue(properties, SERVICE_ATTRIBUTE));
        this.portCombo.setText(this.getPropertyValue(properties, PORT_ATTRIBUTE));
    }

    public void saveTo(IMessageFlowNode node, PropertyCollectionMap props) {
        PropertyCollection properties = node.getPropertiesForEdit(node.getElement());
        properties.setProperty(WSDL_ATTRIBUTE, this.wsdlLocationText.getText());
        properties.setProperty(SERVICE_ATTRIBUTE, this.serviceCombo.getText());
        properties.setProperty(PORT_ATTRIBUTE, this.portCombo.getText());
    }

    private Combo createSimpleComboBox(Composite composite, String label, boolean enabled) {
        new Label(composite, 0).setText(label);
        Combo combo = new Combo(composite, -1);
        combo.setEnabled(enabled);
        GridDataFactory.fillDefaults().span(2, 0).applyTo((Control)combo);
        return combo;
    }

    private void initWsdlLocationWidget(Composite composite, IProject project) {
        new Label(composite, 0).setText("WSDL Location:");
        this.wsdlLocationText = new StyledText(composite, 2048);
        this.wsdlLocationText.setMargins(2, 2, 2, 2);
        this.wsdlLocationText.addModifyListener(this.wsdlLocationModifyListener(project));
        GridDataFactory.fillDefaults().grab(true, false).align(4, 0x1000000).applyTo((Control)this.wsdlLocationText);
        this.pickFileButton = new Button(composite, 8);
        this.pickFileButton.setText("...");
        this.pickFileButton.addSelectionListener((SelectionListener)this.pickFilebuttonSelectionListener(project));
        GridDataFactory.swtDefaults().applyTo((Control)this.pickFileButton);
    }

    private Group getGroup(AttributesPropertyPage parentPage) {
        Group parent = null;
        Control[] controlArray = parentPage.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Group group;
            Control control = controlArray[n2];
            if (control instanceof Group && (group = (Group)control).getText().equalsIgnoreCase("General")) {
                parent = group;
                break;
            }
            ++n2;
        }
        if (parent == null) {
            parent = new Group((Composite)parentPage, 0);
            parent.setText("General");
        }
        return parent;
    }

    private ModifyListener serviceComboModifyListener() {
        return e -> {
            if (!StringUtils.isBlank((String)this.serviceCombo.getText())) {
                this.portCombo.setEnabled(true);
                ServiceModel service = this.wsdlModel.getService(this.serviceCombo.getText());
                this.portCombo.setItems(this.getPortNames(service));
                if (this.portCombo.getItemCount() == 1) {
                    this.portCombo.select(0);
                }
            } else {
                this.portCombo.removeAll();
                this.portCombo.setEnabled(false);
            }
        };
    }

    private SelectionAdapter pickFilebuttonSelectionListener(final IProject selectedProject) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Object[] results;
                FilteredResourcesSelectionDialog dialog = this.filteredSelectionDialog();
                dialog.setTitle("Select WSDL File");
                if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                    IResource file = (IResource)results[0];
                    SoapkitConfigWidget.this.wsdlLocationText.setText(file.getName());
                }
            }

            private FilteredResourcesSelectionDialog filteredSelectionDialog() {
                FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(Display.getCurrent().getActiveShell(), false, (IContainer)selectedProject, 1){

                    protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                        return new FilteredResourcesSelectionDialog.ResourceFilter(this, (IContainer)selectedProject, false, 1){

                            public boolean matchItem(Object item) {
                                return super.matchItem(item);
                            }
                        };
                    }
                };
                dialog.setInitialPattern("*.wsdl");
                return dialog;
            }
        };
    }

    private ModifyListener wsdlLocationModifyListener(IProject project) {
        return e -> {
            String resourcePath = SoapkitUtils.findWsdlResourceFile(project, this.wsdlLocationText.getText());
            this.wsdlModel = SoapkitUtils.definitionFromLocation(resourcePath);
            if (this.wsdlModel != null) {
                this.serviceCombo.setEnabled(true);
                this.serviceCombo.setItems(this.getServiceNames(this.wsdlModel));
                if (this.serviceCombo.getItemCount() == 1) {
                    this.serviceCombo.select(0);
                } else {
                    this.portCombo.removeAll();
                    this.portCombo.setEnabled(false);
                }
            } else {
                this.serviceCombo.removeAll();
                this.portCombo.removeAll();
                this.serviceCombo.setEnabled(false);
                this.portCombo.setEnabled(false);
            }
        };
    }

    private String[] getServiceNames(WsdlModel wsdlModel) {
        return (String[])wsdlModel.getServices().stream().map(ServiceModel::getName).toArray(String[]::new);
    }

    private String[] getPortNames(ServiceModel serviceModel) {
        return (String[])serviceModel.getPorts().stream().map(PortModel::getName).toArray(String[]::new);
    }

    public String getPropertyValue(PropertyCollection props, String name) {
        Property property = props.getProperty(name);
        return property != null ? property.getValue() : "";
    }
}

