/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.utils;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.plexus.util.xml.pull.MXParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.core.runtime.URIUtil;

public class WSDLUtils {
    private static final String DEFAULT_NAMESPACE = "__default_namespace__" + System.currentTimeMillis();

    private WSDLUtils() {
    }

    public static boolean isWsdlFile(String stringValue) {
        MXParser mxParser = new MXParser();
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(URIUtil.fromString((String)("file:" + stringValue)).toURL().openStream());){
                mxParser.setInput((Reader)inputStreamReader);
                if (WSDLUtils.advanceToRootNode(mxParser)) {
                    List<String> wsdlPrefixes = WSDLUtils.findWsdlNamespacePrefixes(mxParser);
                    String rootNodeName = mxParser.getName();
                    boolean usesDefaultNamespace = !rootNodeName.contains(":");
                    String expectedNamespace = usesDefaultNamespace ? DEFAULT_NAMESPACE : rootNodeName.split(":")[0];
                    return wsdlPrefixes.contains(expectedNamespace);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {}
        return false;
    }

    private static boolean advanceToRootNode(MXParser mxParser) throws IOException {
        int eventType = WSDLUtils.next(mxParser);
        while (eventType != 2) {
            if (eventType == -1) {
                return false;
            }
            eventType = WSDLUtils.next(mxParser);
        }
        return true;
    }

    private static List<String> findWsdlNamespacePrefixes(MXParser mxParser) {
        ArrayList<String> wsdlPrefixes = new ArrayList<String>();
        int i = 0;
        while (i < mxParser.getAttributeCount()) {
            if (mxParser.getAttributeValue(i).matches("http://schemas\\.xmlsoap\\.org/wsdl/?")) {
                String attributeName = mxParser.getAttributeName(i);
                wsdlPrefixes.add(attributeName.contains(":") ? attributeName.split(":")[1] : DEFAULT_NAMESPACE);
            }
            ++i;
        }
        return wsdlPrefixes;
    }

    private static int next(MXParser parser) throws IOException {
        try {
            parser.next();
            return parser.getEventType();
        }
        catch (XmlPullParserException xmlPullParserException) {
            return -1;
        }
        catch (NullPointerException nullPointerException) {
            return -1;
        }
        catch (EOFException eOFException) {
            return -1;
        }
    }
}

