/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.scaffolder;

import com.google.common.base.Optional;
import java.io.InputStream;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.soapkit.scaffolder.Scaffolder;
import org.mule.soapkit.scaffolder.model.MuleConfig;
import org.mule.soapkit.scaffolder.model.SoapkitConfig;
import org.mule.tooling.core.cache.IMuleConfigurationsCache;
import org.mule.tooling.core.io.IMuleResources;
import org.mule.tooling.core.model.IMuleApplicationProject;
import org.mule.tooling.core.model.IMuleDomainProject;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.model.MuleProjectKind;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.GlobalElement;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.decorator.PropertyCollectionMap;
import org.mule.tooling.soapkit.common.SoapkitUtils;
import org.mule.tooling.soapkit.scaffolder.ArtifactDeclarationUtils;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.metadata.MetadataStatus;
import org.mule.tooling.ui.modules.core.metadata.action.DataSenseOperation;
import org.mule.tooling.ui.modules.core.metadata.action.GetMetadataKeys;
import org.mule.tooling.ui.modules.core.metadata.queue.DataSenseProcessorQueue;

public class FlowGenerator {
    private static final Scaffolder SCAFFOLDER = Scaffolder.getInstance();
    private static final String MENU_ENTRY_NAME = "Generate flows for WSDL";
    private static final String APIKIT_FOR_SOAP_ELEMENT_NAME = "apikit-for-soap";

    public static void scaffoldNewConfig(IProgressMonitor monitor, IMuleProject muleProject, IFile muleConfig, String wsdlLocation, String wsdlAttribute, String service, String port) throws CoreException {
        IProject project = muleProject.getJavaProject().getProject();
        monitor.subTask("Running scaffolder...");
        ArtifactDeclaration declaration = SCAFFOLDER.scaffold(wsdlLocation, wsdlAttribute, service, port, FlowGenerator.getDomain(muleProject));
        String declarationAsString = FlowGenerator.serializeConfig(muleProject, declaration);
        FlowGenerator.writeMuleXmlFile(monitor, declarationAsString, (IResource)muleConfig);
        monitor.worked(1);
        project.refreshLocal(2, monitor);
        monitor.subTask("Creating necessary Mule configurations ...");
        monitor.worked(1);
        IMuleConfigurationsCache configurationsCache = muleProject.getConfigurationsCache();
        MuleConfiguration configuration = configurationsCache.getConfiguration(muleConfig);
        FlowGenerator.fetchMetadataKeys(configuration, muleProject);
        monitor.subTask("Fetching Metadata ...");
        monitor.worked(1);
    }

    private static String serializeConfig(IMuleProject muleProject, ArtifactDeclaration declaration) throws CoreException {
        try {
            return ArtifactDeclarationUtils.serializeDeclaration(muleProject, declaration);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.apikit.soap", "Problem generating config file: ", (Throwable)e));
        }
    }

    public static List<IFile> scaffoldExistingConfigs(IProgressMonitor monitor, IMuleProject muleProject) throws CoreException {
        monitor.subTask("Scaffolding new flows ...");
        LinkedList<IFile> scaffoldedConfigs = new LinkedList<IFile>();
        List resources = muleProject.getConfigurationsCache().getConfigurationResources();
        for (IFile muleConfig : resources) {
            Optional<SoapkitConfig> optionalSoapkitConfig = FlowGenerator.findSoapkitConfig(muleProject, muleConfig);
            if (!optionalSoapkitConfig.isPresent()) continue;
            SoapkitConfig soapkitConfig = (SoapkitConfig)optionalSoapkitConfig.get();
            if (!CoreUtils.areNotBlank((String[])new String[]{soapkitConfig.getService(), soapkitConfig.getPort()})) continue;
            FlowGenerator.scaffoldWithConfig(muleProject, muleConfig, (SoapkitConfig)optionalSoapkitConfig.get(), monitor);
            scaffoldedConfigs.add(muleConfig);
        }
        if (!scaffoldedConfigs.isEmpty()) {
            muleProject.getJavaProject().getProject().refreshLocal(2, monitor);
        } else {
            MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)MENU_ENTRY_NAME, (String)"There are no Mule configurations currently containing apikit-for-soap routers configured that can be regenerated.\nAdd a WDSL file to your project and generate the configuration by right-clicking on it and using this same option.");
        }
        return scaffoldedConfigs;
    }

    public static void scaffoldExistingConfig(IProgressMonitor monitor, IFile file, String wsdlPath, String service, String port, IMuleProject muleProject) throws CoreException {
        monitor.subTask("Scaffolding new flows ...");
        String wsdlLocation = new Path(wsdlPath).makeRelativeTo(muleProject.getFolder("src/main/resources/api").getLocation()).toOSString();
        SoapkitConfig soapkitConfig = new SoapkitConfig(wsdlLocation, service, port);
        if (CoreUtils.areNotBlank((String[])new String[]{soapkitConfig.getService(), soapkitConfig.getPort()})) {
            FlowGenerator.scaffoldWithConfig(muleProject, file, soapkitConfig, monitor);
        }
        muleProject.getJavaProject().getProject().refreshLocal(2, monitor);
    }

    private static void scaffoldWithConfig(IMuleProject muleProject, IFile muleConfig, SoapkitConfig soapkitApiConfig, IProgressMonitor monitor) throws CoreException {
        try {
            String wsdl = SoapkitUtils.findWsdlResourceFile(muleProject, soapkitApiConfig.getWsdlPath());
            ArtifactDeclaration domain = FlowGenerator.getDomain(muleProject);
            ArtifactDeclaration baseDeclaration = ArtifactDeclarationUtils.loadConfig(muleProject, muleConfig);
            ArtifactDeclaration artifactDeclarationResult = SCAFFOLDER.scaffold(baseDeclaration, wsdl, soapkitApiConfig, domain);
            String resultElement = FlowGenerator.serializeConfig(muleProject, artifactDeclarationResult);
            FlowGenerator.writeMuleXmlFile(monitor, resultElement, (IResource)muleConfig);
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.apikit.soap", "Problem parsing config file: " + muleConfig.getLocation(), (Throwable)e));
        }
    }

    private static ArtifactDeclaration getDomain(IMuleProject muleProject) {
        Optional<IFile> domainFile = FlowGenerator.getDomainFile(muleProject);
        if (domainFile.isPresent()) {
            try {
                return ArtifactDeclarationUtils.loadConfig(muleProject, (IFile)domainFile.get());
            }
            catch (Exception exception) {}
        }
        return ArtifactDeclarationUtils.emptyDeclaration();
    }

    private static Optional<IFile> getDomainFile(IMuleProject muleProject) {
        IMuleDomainProject domain;
        IMuleApplicationProject appProject = (IMuleApplicationProject)MuleProjectKind.APPLICATION.adapt(muleProject);
        IMuleDomainProject iMuleDomainProject = domain = appProject.hasDefaultDomain() ? null : (IMuleDomainProject)appProject.getDomain();
        if (domain != null) {
            return Optional.of((Object)muleProject.getMuleAppsFolder().getFile(IMuleResources.MULE_DOMAIN_CONFIG_FILE_NAME));
        }
        return Optional.absent();
    }

    private static Optional<SoapkitConfig> findSoapkitConfig(IMuleProject muleProject, IFile muleConfig) throws CoreException {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (InputStream contents = muleConfig.getContents();){
                ArtifactDeclaration declaration = ArtifactDeclarationUtils.loadConfig(muleProject, muleConfig);
                List soapkitConfigs = new MuleConfig(declaration).soapkitConfigs();
                if (soapkitConfigs.isEmpty()) {
                    return Optional.absent();
                }
                return Optional.of((Object)((SoapkitConfig)soapkitConfigs.get(0)));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.mule.tooling.apikit.soap", "Problem parsing config file: " + muleConfig.getLocation(), (Throwable)e));
        }
    }

    private static void writeMuleXmlFile(IProgressMonitor monitor, String element, IResource muleConfig) throws CoreException {
        InputStream inputStream = null;
        try {
            inputStream = IOUtils.toInputStream((String)element);
            if (muleConfig.exists()) {
                ((IFile)muleConfig).setContents(inputStream, true, true, monitor);
            } else {
                ((IFile)muleConfig).create(inputStream, true, monitor);
            }
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    private static void fetchMetadataKeys(MuleConfiguration muleConfiguration, IMuleProject muleProject) {
        GlobalElement configReferenceObject;
        MetadataStatus status;
        String configReferenceName = "soapkit-config";
        if (MetadataHelpers.configUsesMetadata((MuleConfiguration)muleConfiguration, (IMuleProject)muleProject, (String)configReferenceName) && (status = MetadataHelpers.getMetadataStatus((PropertyCollectionMap)(configReferenceObject = CoreUtils.retrieveGlobalElement((MuleConfiguration)muleConfiguration, (IMuleProject)muleProject, (String)configReferenceName)).getProperties().toPropertyCollectionMap(), (IMessageFlowNode)configReferenceObject)) == MetadataStatus.DYNAMIC) {
            GetMetadataKeys getMetadataKeys = new GetMetadataKeys(muleProject, muleConfiguration, (IMessageFlowNode)configReferenceObject, false);
            DataSenseProcessorQueue.getInstance().queue((DataSenseOperation)getMetadataKeys);
        }
    }
}

