/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.scaffolder;

import org.eclipse.core.resources.IFile;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.fluent.ElementDeclarer;
import org.mule.tooling.client.ToolingClientFactory;
import org.mule.tooling.client.api.ToolingClient;
import org.mule.tooling.client.api.ToolingSerializationService;
import org.mule.tooling.client.startup.ToolingManager;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.runtime.controller.IMuleInstance;

public class ArtifactDeclarationUtils {
    private ArtifactDeclarationUtils() {
    }

    public static ArtifactDeclaration loadConfig(IMuleProject muleProject, IFile xml) throws Exception {
        ToolingSerializationService serializationService = ArtifactDeclarationUtils.getSerializationService(muleProject);
        return serializationService.loadMuleConfiguration(muleProject, xml);
    }

    public static String serializeDeclaration(IMuleProject muleProject, ArtifactDeclaration declaration) throws Exception {
        ToolingSerializationService serializationService = ArtifactDeclarationUtils.getSerializationService(muleProject);
        return serializationService.serializeMuleConfiguration(muleProject, declaration);
    }

    public static ArtifactDeclaration emptyDeclaration() {
        return (ArtifactDeclaration)ElementDeclarer.newArtifact().getDeclaration();
    }

    private static ToolingSerializationService getSerializationService(IMuleProject muleProject) throws Exception {
        IMuleInstance instance = ToolingManager.getInstance().getToolingInstance();
        ToolingClient toolingClient = ToolingClientFactory.buildToolingClient((IMuleInstance)instance, (IMuleProject)muleProject);
        return toolingClient.getArtifactSerializationService();
    }
}

