/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.handler;

import com.google.common.base.Optional;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.MuleRuntime;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.editor.MultiPageMessageFlowEditor;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.soapkit.analytics.EventTracker;
import org.mule.tooling.soapkit.common.ProjectMavenizer;
import org.mule.tooling.soapkit.common.SoapkitUtils;
import org.mule.tooling.soapkit.handler.ChooseScaffoldingTargetDialog;
import org.mule.tooling.soapkit.scaffolder.FlowGenerator;
import org.mule.tooling.ui.utils.SaveModifiedResourcesDialog;
import org.mule.tooling.ui.utils.UiUtils;
import org.mule.wsdl.parser.WsdlParser;

public class GenerateFlowsHandler
extends AbstractHandler {
    public boolean isEnabled() {
        IMuleProject project = UiUtils.getSelectedMuleProjectInPackageExplorer();
        return project != null && SoapkitUtils.isSupportedServer(project.getServerDefinition());
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection selection = window.getSelectionService().getSelection();
        if (selection instanceof IStructuredSelection) {
            try {
                Optional<IFile> fileFromSelection = this.getFileFromSelection((IStructuredSelection)selection);
                IMuleProject muleProject = this.getMuleProject(fileFromSelection);
                if (!SoapkitUtils.hasSoapkit(muleProject)) {
                    new ProjectMavenizer().execute(muleProject);
                }
                this.doExecute(fileFromSelection, muleProject, (IProgressMonitor)new NullProgressMonitor());
                SoapkitUtils.addSoapkitExtensionIfAbsent(muleProject);
            }
            catch (CoreException e) {
                MuleCorePlugin.logError((String)"There was a problem scaffolding new flows from WSDL", (Throwable)e);
                ErrorDialog.openError((Shell)window.getShell(), (String)"Error creating flows", (String)"There was an error scaffolding new flows from WSDL.", (IStatus)GenerateFlowsHandler.createMultiStatus(e));
            }
        }
        return null;
    }

    private static MultiStatus createMultiStatus(Throwable t) {
        StringWriter errors = new StringWriter();
        t.printStackTrace(new PrintWriter(errors));
        Status[] childStatuses = new Status[]{new Status(4, "org.mule.tooling.apikit.soap", errors.toString())};
        return new MultiStatus("org.mule.tooling.apikit.soap", 4, (IStatus[])childStatuses, t.getMessage(), t);
    }

    private void doExecute(Optional<IFile> fileFromSelection, IMuleProject muleProject, IProgressMonitor monitor) throws CoreException {
        EventTracker eventTracker = new EventTracker();
        try {
            try {
                IProject project = muleProject.getJavaProject().getProject();
                this.saveModifiedResources(project);
                project.refreshLocal(2, null);
                List<IFile> scaffolded = Collections.emptyList();
                if (fileFromSelection.isPresent()) {
                    IFile iFile = (IFile)fileFromSelection.get();
                    IFolder apisFolder = project.getFolder("src/main/resources/api");
                    if (!apisFolder.getFullPath().isPrefixOf(iFile.getFullPath())) {
                        MessageDialog.openWarning((Shell)this.getShell(), (String)"Generate flows from WSDL", (String)"The file should be located in '/src/main/resources/api' to be able to generate flows.");
                        eventTracker.setStatus("Internal Error");
                    } else {
                        Map<String, List<String>> servicesAndPorts = SoapkitUtils.getServicesAndPorts(WsdlParser.Companion.parse(iFile.getLocation().toOSString(), StandardCharsets.UTF_8.toString()));
                        if (this.hasOneValue(servicesAndPorts)) {
                            ChooseScaffoldingTargetDialog dialog = ChooseScaffoldingTargetDialog.createFor(iFile, muleProject, servicesAndPorts);
                            int open = dialog.open();
                            if (open == 0) {
                                scaffolded = this.scaffold(muleProject, monitor, iFile, dialog, eventTracker);
                                eventTracker.setStatus("Succeed");
                            } else {
                                eventTracker.setStatus("Cancelled By User");
                            }
                        } else {
                            MessageDialog.openWarning((Shell)this.getShell(), (String)"Generate flows from WSDL", (String)"The selected WSDL has no service/port declarations or could not be parsed correctly.");
                            eventTracker.setStatus("Syntax Error");
                        }
                    }
                } else {
                    eventTracker.setRescaffolding(true);
                    scaffolded = FlowGenerator.scaffoldExistingConfigs(monitor, muleProject);
                    eventTracker.setStatus("Succeed");
                }
                this.refreshEditors(scaffolded);
            }
            catch (Exception e) {
                eventTracker.setStatus("Internal Error");
                throw e;
            }
        }
        finally {
            eventTracker.trackEvent();
            monitor.done();
        }
    }

    private void refreshEditors(List<IFile> scaffolded) {
        HashSet<IFile> configsSet = new HashSet<IFile>(scaffolded);
        Collection openMultipageMessageFlowEditors = MessageFlowUtils.getOpenMultipageMessageFlowEditors();
        for (MultiPageMessageFlowEditor multiPageMessageFlowEditor : openMultipageMessageFlowEditors) {
            IFile editorInput = multiPageMessageFlowEditor.getFlowEditor().getInputXmlConfigFile();
            if (!configsSet.contains(editorInput)) continue;
            multiPageMessageFlowEditor.updateFlowFromSource();
            multiPageMessageFlowEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }
    }

    private List<IFile> scaffold(IMuleProject muleProject, IProgressMonitor monitor, IFile iFile, ChooseScaffoldingTargetDialog dialog, EventTracker eventTracker) throws CoreException, PartInitException {
        IFile muleConfig = dialog.getMuleConfig();
        String wsdlFileLocation = iFile.getLocation().toOSString();
        String wsdlRelativePath = iFile.getFullPath().makeRelativeTo(muleProject.getFolder("src/main/resources/api").getFullPath()).toOSString();
        if (dialog.createNewFile()) {
            eventTracker.setRescaffolding(false);
            FlowGenerator.scaffoldNewConfig(monitor, muleProject, muleConfig, wsdlFileLocation, wsdlRelativePath, dialog.getService(), dialog.getPort());
        } else {
            eventTracker.setRescaffolding(true);
            FlowGenerator.scaffoldExistingConfig(monitor, muleConfig, wsdlFileLocation, dialog.getService(), dialog.getPort(), muleProject);
        }
        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)muleConfig);
        return Collections.singletonList(muleConfig);
    }

    private boolean hasOneValue(Map<String, List<String>> servicesAndPorts) {
        Collection<List<String>> values = servicesAndPorts.values();
        for (List<String> list : values) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private IMuleProject getMuleProject(Optional<IFile> fileFromSelection) throws CoreException {
        IMuleProject muleProject = fileFromSelection.isPresent() ? MuleRuntime.create((IProject)((IFile)fileFromSelection.get()).getProject()) : MuleCorePlugin.getDesignContext().getMuleProject();
        return muleProject;
    }

    private Optional<IFile> getFileFromSelection(IStructuredSelection selection) {
        Object firstElement;
        if (!selection.isEmpty() && (firstElement = selection.getFirstElement()) instanceof IFile) {
            IFile file = (IFile)firstElement;
            return Optional.of((Object)file);
        }
        return Optional.absent();
    }

    private boolean saveModifiedResources(IProject project) {
        List dirtyEditors = UiUtils.getDirtyEditors((IProject)project);
        if (dirtyEditors.isEmpty()) {
            return true;
        }
        Shell shell = this.getShell();
        SaveModifiedResourcesDialog dialog = new SaveModifiedResourcesDialog(shell);
        return dialog.open(shell, dirtyEditors);
    }

    private Shell getShell() {
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        return shell;
    }
}

