/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.handler;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.soapkit.ServicePortChooser;

public class ChooseScaffoldingTargetDialog
extends Dialog {
    private static final Path NEW_CONFIG_FILE = new Path("New configuration file");
    private IMuleProject muleProject;
    private IFile wsdlFile;
    private Map<String, List<String>> servicesAndPorts;
    private ServicePortChooser servicePortChooser;
    private ComboViewer targetFileCombo;
    private IPath selectedTargetFile;

    protected ChooseScaffoldingTargetDialog(Shell parentShell, IMuleProject muleProject, IFile wsdlFile, Map<String, List<String>> servicesAndPorts) {
        super(parentShell);
        this.muleProject = muleProject;
        this.wsdlFile = wsdlFile;
        this.servicesAndPorts = servicesAndPorts;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Generate flows from WSDL");
    }

    protected Control createDialogArea(Composite grandparent) {
        Composite parent = (Composite)super.createDialogArea(grandparent);
        this.servicePortChooser = new ServicePortChooser();
        Composite servicePortChooserComposite = this.servicePortChooser.createControl(parent, 2);
        this.servicePortChooser.setInput(this.servicesAndPorts);
        this.targetFileCombo = this.createTargetFileCombo(servicePortChooserComposite);
        ArrayList<Object> targetFiles = new ArrayList<Object>();
        try {
            List configurationResources = this.muleProject.getConfigurationsCache().getConfigurationResources();
            for (IFile configFile : configurationResources) {
                targetFiles.add(configFile.getProjectRelativePath());
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        targetFiles.add(NEW_CONFIG_FILE);
        this.targetFileCombo.setInput(targetFiles);
        this.targetFileCombo.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChooseScaffoldingTargetDialog.this.selectedTargetFile = (IPath)((IStructuredSelection)ChooseScaffoldingTargetDialog.this.targetFileCombo.getSelection()).getFirstElement();
            }
        });
        this.targetFileCombo.setSelection((ISelection)new StructuredSelection(targetFiles.get(0)));
        return parent;
    }

    private ComboViewer createTargetFileCombo(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText("Destination file:");
        GridDataFactory.swtDefaults().applyTo((Control)label);
        ComboViewer comboViewer = new ComboViewer(composite, 12);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridDataFactory.fillDefaults().grab(true, false).hint(200, -1).applyTo(comboViewer.getControl());
        return comboViewer;
    }

    public static ChooseScaffoldingTargetDialog createFor(IFile iFile, IMuleProject muleProject, Map<String, List<String>> servicesAndPorts) {
        ChooseScaffoldingTargetDialog chooseScaffoldingTargetDialog = new ChooseScaffoldingTargetDialog(Display.getCurrent().getActiveShell(), muleProject, iFile, servicesAndPorts);
        chooseScaffoldingTargetDialog.setBlockOnOpen(true);
        return chooseScaffoldingTargetDialog;
    }

    public boolean createNewFile() {
        return this.selectedTargetFile.equals((Object)NEW_CONFIG_FILE);
    }

    public IFile getMuleConfig() {
        IFile file;
        if (this.createNewFile()) {
            String baseName = FilenameUtils.getBaseName((String)this.wsdlFile.getName());
            String extension = "xml";
            int i = 0;
            do {
                file = this.muleProject.getMuleAppsFolder().getFile(String.valueOf(baseName) + (i > 0 ? "-" + i : "") + "." + extension);
                ++i;
            } while (file.exists());
        } else {
            file = this.muleProject.getFile(this.selectedTargetFile.toOSString());
        }
        return file;
    }

    public String getService() {
        return this.servicePortChooser.getSelectedService();
    }

    public String getPort() {
        return this.servicePortChooser.getSelectedPort();
    }
}

