/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.common;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.mule.soapkit.scaffolder.exceptions.ParserException;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.m2.utils.MavenUtils;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.module.runner.ArtifactResolvingRunnerFactory;
import org.mule.tooling.core.module.runner.SingleExtensionCallback;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.model.project.MuleExtension;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.PortModel;
import org.mule.wsdl.parser.model.ServiceModel;
import org.mule.wsdl.parser.model.WsdlModel;

public class SoapkitUtils {
    private static String SOAPKIT_GROUP_ID;
    private static String SOAPKIT_ARTIFACT_ID;
    private static String SOAPKIT_VERSION;
    private static final String SOAPKIT_COORDINATES;
    private static final String SUPPORTED_SERVERS = "[4.1.0,10.0.0]";

    static {
        try {
            Properties projectProperties = new Properties();
            projectProperties.load(SoapkitUtils.class.getResourceAsStream("/project.properties"));
            SOAPKIT_GROUP_ID = projectProperties.getProperty("soapkitGroupId");
            SOAPKIT_ARTIFACT_ID = projectProperties.getProperty("soapkitArtifactId");
            SOAPKIT_VERSION = projectProperties.getProperty("soapkitVersion");
        }
        catch (IOException iOException) {
            throw new ParserException("Unable to find project.properties file");
        }
        SOAPKIT_COORDINATES = String.valueOf(SOAPKIT_GROUP_ID) + ":" + SOAPKIT_ARTIFACT_ID + ":" + SOAPKIT_VERSION;
    }

    public static boolean hasSoapkit(IMuleProject muleProject) {
        List declaredExtensions = muleProject.getDeclaredExtensions();
        for (MuleExtension muleExtension : declaredExtensions) {
            if (!SoapkitUtils.isSoapkit(muleExtension)) continue;
            return true;
        }
        return false;
    }

    public static void addSoapkitExtensionIfAbsent(IMuleProject muleProject) {
        SoapkitUtils.addSoapkitExtensionIfAbsent(muleProject, (IProgressMonitor)new NullProgressMonitor(), ignoredError -> {});
    }

    public static void addSoapkitExtensionIfAbsent(IMuleProject muleProject, IProgressMonitor monitor, Consumer<String> onError) {
        if (!SoapkitUtils.hasSoapkit(muleProject)) {
            MavenDependency dependency = SoapkitUtils.getSoapkitDependency();
            ArtifactResolvingRunnerFactory.syncInstance().runResolvingExtension(muleProject, dependency, SingleExtensionCallback.builder().onSuccess(module -> {
                try {
                    muleProject.addMuleExtension(module);
                }
                catch (CoreException e) {
                    SoapkitUtils.showError(e);
                }
            }).onError(errors -> {
                CoreException exception = new CoreException((IStatus)new Status(4, "org.mule.tooling.apikit.soap", "An error occurred resolving " + SOAPKIT_COORDINATES + ": " + ArtifactResolvingRunnerFactory.getErrorsMessage((Map)errors)));
                SoapkitUtils.showError(exception);
            }).build(), monitor);
        }
    }

    private static void showError(CoreException e) {
        Display.getDefault().asyncExec(() -> MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)("There was a problem adding " + SOAPKIT_COORDINATES), (String)e.getMessage()));
    }

    static MavenDependency getSoapkitDependency() {
        return MavenUtils.getPluginDependency((String)SOAPKIT_COORDINATES);
    }

    private static boolean isSoapkit(MuleExtension muleExtension) {
        return SOAPKIT_COORDINATES.equals(muleExtension.getName());
    }

    public static WsdlModel definitionFromLocation(String wsdlPath) {
        WsdlModel wsdlModel = null;
        if (StringUtils.isNotBlank((String)wsdlPath)) {
            try {
                wsdlModel = WsdlParser.Companion.parse(wsdlPath);
            }
            catch (Exception exception) {}
        }
        return wsdlModel;
    }

    public static String findWsdlResourceFile(IProject project, String filePath) {
        if (SoapkitUtils.isUrl(filePath)) {
            return filePath;
        }
        IFolder folder = project.getFolder("src/main/resources/api");
        IFile file = folder.getFile(filePath);
        if (file.exists()) {
            return file.getLocation().toOSString();
        }
        return "";
    }

    public static String findWsdlResourceFile(IMuleProject project, String filePath) {
        return SoapkitUtils.findWsdlResourceFile(project.getJavaProject().getProject(), filePath);
    }

    public static boolean isUrl(String url) {
        return url.startsWith("http:") || url.startsWith("https:");
    }

    public static boolean isSupportedServer(IServerDefinition selectedServer) {
        return ServerMatcher.fromString((String)SUPPORTED_SERVERS).matches(selectedServer);
    }

    public static Map<String, List<String>> getServicesAndPorts(WsdlModel wsdlModel) {
        List serviceNames = wsdlModel.getServices();
        HashMap<String, List<String>> servicesAndPorts = new HashMap<String, List<String>>(serviceNames.size());
        for (ServiceModel service : serviceNames) {
            ArrayList<String> portNames = new ArrayList<String>();
            for (PortModel portModel : service.getPorts()) {
                portNames.add(portModel.getName());
            }
            servicesAndPorts.put(service.getName(), portNames);
        }
        return servicesAndPorts;
    }
}

