/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit.common;

import org.eclipse.core.resources.ResourcesPlugin;
import org.mule.tooling.core.m2.dependency.MavenDependency;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.IMavenModel;
import org.mule.tooling.maven.MavenMuleProjectDecorator;
import org.mule.tooling.maven.ui.mavenize.MavenizeAction;
import org.mule.tooling.maven.utils.MavenUtils;
import org.mule.tooling.soapkit.common.SoapkitUtils;

public class ProjectMavenizer
implements MavenizeAction {
    public boolean applies(IMuleProject muleProject) {
        return SoapkitUtils.hasSoapkit(muleProject);
    }

    public String getDescription(IMuleProject muleProject, IMavenModel mavenModel) {
        return "Add APIkit Soap Maven Support to the project pom.xml file";
    }

    public boolean execute(IMuleProject muleProject, IMavenModel mavenModel) {
        if (muleProject == null) {
            return false;
        }
        if (!ResourcesPlugin.getWorkspace().isTreeLocked() && MavenUtils.isMavenBased((IMuleProject)muleProject)) {
            MavenMuleProjectDecorator mavenMuleProjectDecorator = MavenMuleProjectDecorator.decorate((IMuleProject)muleProject);
            if (SoapkitUtils.isSupportedServer(muleProject.getServerDefinition())) {
                MavenDependency soapkitModule = SoapkitUtils.getSoapkitDependency();
                mavenMuleProjectDecorator.addDependency(soapkitModule);
            }
            return true;
        }
        return false;
    }

    public boolean execute(IMuleProject muleProject) {
        return this.execute(muleProject, null);
    }
}

