/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit;

import com.google.common.base.Optional;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.mule.tooling.apikit.common.apidefinition.ApiDefinitionContribution;
import org.mule.tooling.apikit.common.apidefinition.StatusHandler;
import org.mule.tooling.core.StudioDesignContextRunner;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.runtime.server.IServerDefinition;
import org.mule.tooling.core.runtime.server.ServerMatcher;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.soapkit.ServicePortChooser;
import org.mule.tooling.soapkit.analytics.EventTracker;
import org.mule.tooling.soapkit.common.ProjectMavenizer;
import org.mule.tooling.soapkit.common.SoapkitUtils;
import org.mule.tooling.soapkit.scaffolder.FlowGenerator;
import org.mule.tooling.soapkit.utils.WSDLUtils;
import org.mule.tooling.ui.authentication.ImportApiResource;
import org.mule.tooling.ui.utils.GrayedTooltipTextListener;
import org.mule.wsdl.parser.WsdlParser;
import org.mule.wsdl.parser.model.WsdlModel;

public class SoapApiDefinitionContribution
implements ApiDefinitionContribution {
    private StatusHandler statusHandler;
    private String wsdlLocation;
    private WsdlModel wsdlModel;
    private IServerDefinition serverDefinition;
    private Composite stackingComposite;
    private StackLayout stackLayout;
    private Composite servicePortComposite;
    private Composite infoComposite;
    private Label infoLabel;
    private ServicePortChooser servicePortChooser;
    private static final Path parentDirectoryPath = new Path("..");
    private EventTracker eventTracker;

    public String getFormatName() {
        return "WSDL";
    }

    public void initialize(StatusHandler statusHandler, IRunnableContext runnableContext) {
        this.statusHandler = statusHandler;
        this.eventTracker = new EventTracker("STUDIO_NEW_PROJECT_WITH_APIKIT_USING_WSDL");
    }

    public boolean handles(ISelection selection) {
        return !this.isEmpty(selection) && this.isWsdl(selection);
    }

    private boolean isWsdl(ISelection selection) {
        boolean isLocalWsdlFile;
        String filePath;
        String string = filePath = selection.isEmpty() ? null : (String)((IStructuredSelection)selection).getFirstElement();
        if (filePath == null) {
            return false;
        }
        boolean bl = isLocalWsdlFile = new File(filePath).exists() && filePath.toLowerCase().endsWith(".wsdl");
        return isLocalWsdlFile || WSDLUtils.isWsdlFile(filePath);
    }

    public Optional<Composite> createAdditionalConfigurationComposite(Composite parent) {
        this.stackingComposite = new Composite(parent, 0);
        this.stackLayout = new StackLayout();
        this.stackingComposite.setLayout((Layout)this.stackLayout);
        this.infoComposite = this.createInfoComposite(this.stackingComposite);
        this.servicePortChooser = new ServicePortChooser();
        this.servicePortComposite = this.servicePortChooser.createControl(this.stackingComposite, 4);
        this.stackLayout.topControl = this.infoLabel;
        return Optional.of((Object)this.stackingComposite);
    }

    private Composite createInfoComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        this.infoLabel = new Label(composite, 0);
        this.infoLabel.setText("");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.infoLabel);
        this.infoLabel.setForeground(GrayedTooltipTextListener.getInactiveColor());
        return composite;
    }

    private boolean isEmpty(ISelection selection) {
        return selection.isEmpty() || StringUtils.isBlank((String)this.getStringValue(selection));
    }

    private String getStringValue(ISelection selection) {
        return (String)((IStructuredSelection)selection).getFirstElement();
    }

    public void performFinish(IProgressMonitor monitor, IRunnableContext runnableContext, IMuleProject muleProject, boolean scaffoldActivated) {
        StudioDesignContextRunner.runSilentWithMuleProjectInUI(() -> {
            SoapkitUtils.addSoapkitExtensionIfAbsent(muleProject);
            if (this.wsdlModel != null) {
                this.createMuleConfig(muleProject, scaffoldActivated);
            }
            return null;
        }, (IMuleProject)muleProject);
        new ProjectMavenizer().execute(muleProject);
    }

    public void onResourceSelectionChanged(ISelection selection, Optional<ImportApiResource> apiVersion) {
        this.wsdlLocation = this.getStringValue(selection);
        try {
            this.wsdlModel = WsdlParser.Companion.parse(this.wsdlLocation);
            if (this.serverDefinition != null && !ServerMatcher.fromString((String)"[3.7,10)").matches(this.serverDefinition)) {
                this.setErrorMessage("Selected runtime doesn't support WSDL wsdlModel");
                return;
            }
            if (this.wsdlModel != null) {
                Map<String, List<String>> servicesAndPorts = SoapkitUtils.getServicesAndPorts(this.wsdlModel);
                if (servicesAndPorts.size() > 0) {
                    if (this.hasOneValue(servicesAndPorts)) {
                        this.servicePortChooser.setInput(servicesAndPorts);
                        this.clearErrors();
                    } else {
                        this.setErrorMessage("Specified WSDL does not contain any port declarations");
                    }
                } else {
                    this.setErrorMessage("Specified WSDL does not contain any service declarations");
                }
            } else {
                this.setErrorMessage("Specified WSDL is an invalid File or URL");
            }
        }
        catch (Exception exception) {
            this.setErrorMessage("Specified WSDL is an invalid File or URL");
        }
    }

    private void clearErrors() {
        this.statusHandler.clearErrors();
        this.statusHandler.setPartComplete(true);
        this.stackLayout.topControl = this.servicePortComposite;
        this.stackingComposite.layout();
    }

    private void setErrorMessage(String errorMessage) {
        this.statusHandler.setPartComplete(false);
        this.statusHandler.setErrorMessage(errorMessage);
        this.infoLabel.setText(errorMessage);
        this.stackLayout.topControl = this.infoComposite;
        this.stackingComposite.layout();
    }

    private boolean hasOneValue(Map<String, List<String>> servicesAndPorts) {
        Collection<List<String>> values = servicesAndPorts.values();
        for (List<String> list : values) {
            if (list.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void createMuleConfig(IMuleProject muleProject, boolean scaffoldActivated) throws CoreException, IOException {
        try {
            try {
                String wsdlRelativePath = this.wsdlLocation;
                if (!CoreUtils.isRemoteUrl((String)this.wsdlLocation)) {
                    wsdlRelativePath = this.copyWsdlFilesToProject(muleProject);
                }
                if (scaffoldActivated) {
                    FlowGenerator.scaffoldNewConfig((IProgressMonitor)new NullProgressMonitor(), muleProject, this.getMuleConfig(muleProject), this.wsdlLocation, wsdlRelativePath, this.servicePortChooser.getSelectedService(), this.servicePortChooser.getSelectedPort());
                }
                this.eventTracker.setStatus("Succeed");
            }
            catch (Exception e) {
                this.eventTracker.setStatus("Internal Error");
                throw e;
            }
        }
        finally {
            this.eventTracker.trackEvent();
        }
    }

    private String copyWsdlFilesToProject(IMuleProject muleProject) throws IOException {
        File apiFolderAsFile = muleProject.getFolder("src/main/resources/api").getRawLocation().toFile();
        int maxUpLevels = this.copyReferencedFilesToProject(apiFolderAsFile);
        File targetFolder = apiFolderAsFile;
        File wsdlFile = new File(this.wsdlLocation);
        Path path = new Path(this.wsdlLocation);
        if (maxUpLevels > 0) {
            IPath pathToWsdl = path.makeUNC(true).removeLastSegments(1);
            pathToWsdl = pathToWsdl.removeFirstSegments(pathToWsdl.segmentCount() - maxUpLevels);
            targetFolder = new File(apiFolderAsFile, pathToWsdl.toOSString());
            targetFolder.mkdirs();
        }
        File destinationFile = new File(targetFolder, wsdlFile.getName());
        FileUtils.copyFile((File)wsdlFile, (File)destinationFile);
        return new Path(destinationFile.getAbsolutePath()).makeRelativeTo(muleProject.getFolder("src/main/resources/api").getLocation()).toOSString();
    }

    private int copyReferencedFilesToProject(File targetFolder) throws IOException {
        String wsdlFolderLocation = new File(this.wsdlLocation).getParent();
        int maxUpLevels = 0;
        for (Map.Entry entry : WsdlParser.Companion.instance(this.wsdlLocation, StandardCharsets.UTF_8.toString()).collectSchemas().entrySet()) {
            try {
                String key = (String)entry.getKey();
                String keyFixed = key.startsWith("file:") ? key.replace("%20", " ") : key;
                URL url = new URL(keyFixed);
                if (!"file".equalsIgnoreCase(url.getProtocol())) continue;
                IPath path = new Path(url.getFile()).makeRelativeTo((IPath)new Path(wsdlFolderLocation));
                int upLevels = 0;
                while (parentDirectoryPath.isPrefixOf(path)) {
                    ++upLevels;
                    path = path.removeFirstSegments(1);
                }
                maxUpLevels = Math.max(maxUpLevels, upLevels);
                if (path.segmentCount() > 1) {
                    new File(targetFolder, path.toFile().getParent()).mkdirs();
                }
                FileUtils.writeByteArrayToFile((File)new File(targetFolder, path.toOSString()), (byte[])((String)entry.getValue()).getBytes(StandardCharsets.UTF_8));
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return maxUpLevels;
    }

    private IFile getMuleConfig(IMuleProject muleProject) throws CoreException {
        IResource[] iResourceArray = muleProject.getMuleAppsFolder().members();
        int n = iResourceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IResource r = iResourceArray[n2];
            if ("xml".equals(r.getFileExtension())) {
                return (IFile)r;
            }
            ++n2;
        }
        String xmlFileName = String.valueOf(File.separator) + muleProject.getName() + "." + "xml";
        return muleProject.getJavaProject().getProject().getFile("src/main/mule" + xmlFileName);
    }

    public void setServerDefinition(IServerDefinition serverDefinition) {
        this.serverDefinition = serverDefinition;
    }
}

