/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.soapkit;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class ServicePortChooser {
    private Map<String, List<String>> servicesAndPorts;
    private ComboViewer serviceComboViewer;
    private ComboViewer portComboViewer;
    private String selectedPort;
    private String selectedService;

    public Composite createControl(Composite parent, int columns) {
        Composite composite = new Composite(parent, 0);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(columns).equalWidth(false).applyTo(composite);
        this.serviceComboViewer = this.createComboViewer(composite, "Service:");
        this.serviceComboViewer.addSelectionChangedListener(this.serviceComboSelectionListener());
        this.portComboViewer = this.createComboViewer(composite, "Port:");
        this.portComboViewer.addSelectionChangedListener(this.portComboSelectionListener());
        return composite;
    }

    public void setInput(Map<String, List<String>> servicesAndPorts) {
        this.servicesAndPorts = servicesAndPorts;
        Set<String> services = servicesAndPorts.keySet();
        this.serviceComboViewer.setInput(services);
        this.serviceComboViewer.setSelection((ISelection)new StructuredSelection((Object)services.iterator().next()));
    }

    public String getSelectedPort() {
        return this.selectedPort;
    }

    public String getSelectedService() {
        return this.selectedService;
    }

    private ComboViewer createComboViewer(Composite composite, String label) {
        Label label1 = new Label(composite, 0);
        label1.setText(label);
        GridDataFactory.swtDefaults().applyTo((Control)label1);
        ComboViewer comboViewer = new ComboViewer(composite, 12);
        comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        GridDataFactory.fillDefaults().grab(true, false).hint(150, -1).applyTo(comboViewer.getControl());
        return comboViewer;
    }

    private ISelectionChangedListener portComboSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServicePortChooser.this.selectedPort = event.getSelection().isEmpty() ? null : ServicePortChooser.this.getStringValue(event.getSelection());
            }
        };
    }

    private ISelectionChangedListener serviceComboSelectionListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                String string = ServicePortChooser.this.selectedService = selection.isEmpty() ? null : ServicePortChooser.this.getStringValue(selection);
                if (!selection.isEmpty()) {
                    ServicePortChooser.this.onServiceSelectionChanged(ServicePortChooser.this.selectedService);
                }
            }
        };
    }

    private void onServiceSelectionChanged(String service) {
        this.selectedService = service;
        List<String> portNames = this.servicesAndPorts.get(service);
        if (portNames != null && !portNames.isEmpty()) {
            this.portComboViewer.setInput(portNames);
            this.portComboViewer.setSelection((ISelection)new StructuredSelection((Object)portNames.get(0)));
        }
    }

    private String getStringValue(ISelection selection) {
        return (String)((IStructuredSelection)selection).getFirstElement();
    }
}

