/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport.config;

import com.mulesoft.agent.common.internalhandler.AbstractSplunkInternalHandler;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.AbstractSplunkConfig;
import com.mulesoft.agent.exception.AgentConfigurationException;
import org.apache.commons.lang.StringUtils;

public class TCPTransportConfig
extends AbstractSplunkConfig {
    @Override
    public String toString() {
        return "TCPTransportConfig{} " + super.toString();
    }

    public static class Builder {
        private TCPTransportConfig config = new TCPTransportConfig();

        public Builder(AbstractSplunkInternalHandler internalHandler) throws AgentConfigurationException {
            try {
                this.config.setHost(internalHandler.getHost());
                this.config.setPort(internalHandler.getPort());
            }
            catch (Exception ex) {
                throw new AgentConfigurationException("There was an error reading the Splunk Configuration.", ex);
            }
            if (StringUtils.isBlank((String)this.config.getHost())) {
                throw new AgentConfigurationException("The host property cannot be blank.");
            }
            if (this.config.getPort() <= 0) {
                throw new AgentConfigurationException("The port property must be positive.");
            }
        }

        public TCPTransportConfig build() {
            return this.config;
        }
    }
}

