/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport.config;

import com.mulesoft.agent.common.internalhandler.AbstractSplunkInternalHandler;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.HttpBasedSplunkConfig;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.HttpScheme;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Password;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.exception.AgentConfigurationException;
import com.splunk.SSLSecurityProtocol;
import org.apache.commons.lang.StringUtils;

public class RestTransportConfig
extends HttpBasedSplunkConfig {
    @Configurable(type=Type.DYNAMIC)
    private String user;
    @Password
    @Configurable(type=Type.DYNAMIC)
    private String pass;

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    @Override
    public String toString() {
        return "RestTransportConfig{user='" + this.user + '\'' + "} " + super.toString();
    }

    public static class Builder {
        private RestTransportConfig config = new RestTransportConfig();

        public Builder(AbstractSplunkInternalHandler internalHandler) throws AgentConfigurationException {
            try {
                this.config.setUser(internalHandler.getUser());
                this.config.setPass(internalHandler.getPass());
                this.config.setHost(internalHandler.getHost());
                this.config.setPort(internalHandler.getPort());
                this.config.setScheme(HttpScheme.valueOf(internalHandler.getScheme().toUpperCase()));
                this.config.setSslSecurityProtocol(SSLSecurityProtocol.valueOf((String)internalHandler.getSslSecurityProtocol()));
                this.config.setIndex(internalHandler.getSplunkIndexName());
                this.config.setSource(internalHandler.getSplunkSource());
                this.config.setSourceType(internalHandler.getSplunkSourceType());
            }
            catch (Exception ex) {
                throw new AgentConfigurationException("There was an error reading the Splunk Configuration.", ex);
            }
            if (StringUtils.isEmpty((String)this.config.getHost()) || StringUtils.isEmpty((String)this.config.getUser()) || StringUtils.isEmpty((String)this.config.getPass()) || this.config.getScheme() == null || this.config.getPort() < 1 || StringUtils.isEmpty((String)this.config.getIndex()) || StringUtils.isEmpty((String)this.config.getSource()) || StringUtils.isEmpty((String)this.config.getSourceType())) {
                throw new AgentConfigurationException("Please review configuration; you must configure the following properties: user, pass and host.");
            }
        }

        public RestTransportConfig build() {
            return this.config;
        }
    }
}

