/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport.config;

import com.mulesoft.agent.common.internalhandler.AbstractSplunkInternalHandler;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.HttpBasedSplunkConfig;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.HttpScheme;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.exception.AgentConfigurationException;
import com.splunk.SSLSecurityProtocol;
import org.apache.commons.lang.StringUtils;

public class HECTransportConfig
extends HttpBasedSplunkConfig {
    @Configurable(type=Type.DYNAMIC)
    private String token;

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    @Override
    public String toString() {
        return "HECTransportConfig{token='" + this.token + '\'' + "} " + super.toString();
    }

    public static class Builder {
        private HECTransportConfig config = new HECTransportConfig();

        public Builder(AbstractSplunkInternalHandler internalHandler) throws AgentConfigurationException {
            try {
                this.config.setToken(internalHandler.getToken());
                this.config.setHost(internalHandler.getHost());
                this.config.setPort(internalHandler.getPort());
                this.config.setScheme(HttpScheme.valueOf(internalHandler.getScheme().toUpperCase()));
                this.config.setSslSecurityProtocol(SSLSecurityProtocol.valueOf((String)internalHandler.getSslSecurityProtocol()));
                this.config.setIndex(internalHandler.getSplunkIndexName());
                this.config.setSource(internalHandler.getSplunkSource());
                this.config.setSourceType(internalHandler.getSplunkSourceType());
                this.config.setAcceptAnyCertificate(internalHandler.getAcceptAnyCertificate());
            }
            catch (Exception ex) {
                throw new AgentConfigurationException("There was an error reading the Splunk Configuration.", ex);
            }
            if (StringUtils.isEmpty((String)this.config.getHost()) || StringUtils.isEmpty((String)this.config.getToken()) || this.config.getScheme() == null || this.config.getPort() < 1 || StringUtils.isEmpty((String)this.config.getIndex()) || StringUtils.isEmpty((String)this.config.getSource()) || this.config.getAcceptAnyCertificate() == null || StringUtils.isEmpty((String)this.config.getSourceType())) {
                throw new AgentConfigurationException("Please review configuration; you must configure the following properties: token and host.");
            }
        }

        public HECTransportConfig build() {
            return this.config;
        }
    }
}

