/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.common.internalhandler.splunk.transport.AbstractTransport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.TCPTransportConfig;
import com.mulesoft.agent.handlers.exception.InitializationException;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TCPTransport<T>
extends AbstractTransport<T> {
    private static final Logger LOGGER = LogManager.getLogger(TCPTransport.class);
    private static final int CONNECTION_TIMEOUT = 10000;
    private TCPTransportConfig config;

    public TCPTransport(TCPTransportConfig config, ObjectMapper objectMapper) {
        super(objectMapper);
        this.config = config;
    }

    @Override
    public void init() throws InitializationException {
        try {
            LOGGER.debug("Connecting to the Splunk server: %s:%s.", (Object)this.config.getHost(), (Object)this.config.getPort());
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), 10000);
            }
            LOGGER.debug("Successfully connected to the Splunk server.");
        }
        catch (Exception e) {
            throw new InitializationException("There was an error connecting to the Splunk server. Please review your settings.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Collection<T> messages) {
        boolean bl;
        Socket socket;
        block13: {
            socket = null;
            OutputStream output = null;
            try {
                socket = new Socket();
                socket.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), 10000);
                output = socket.getOutputStream();
                for (T message : messages) {
                    this.serializeTo(message, output);
                }
                bl = true;
                if (output == null) break block13;
            }
            catch (IOException e) {
                boolean bl2;
                block14: {
                    try {
                        LOGGER.error("There was an error sending the notifications to the Splunk instance.", (Throwable)e);
                        bl2 = false;
                        if (output == null) break block14;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (output != null) {
                                output.close();
                            }
                            if (socket != null) {
                                socket.close();
                            }
                            throw throwable;
                        }
                        catch (IOException e2) {
                            LOGGER.error("There was an error closing the communication to the Splunk instance.", (Throwable)e2);
                            return false;
                        }
                    }
                    output.close();
                }
                if (socket != null) {
                    socket.close();
                }
                return bl2;
            }
            output.close();
        }
        if (socket != null) {
            socket.close();
        }
        return bl;
    }

    @Override
    public void dispose() {
    }
}

