/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.common.internalhandler.splunk.transport.AbstractTransport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.HttpScheme;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.RestTransportConfig;
import com.mulesoft.agent.handlers.exception.InitializationException;
import com.splunk.Args;
import com.splunk.Index;
import com.splunk.SSLSecurityProtocol;
import com.splunk.Service;
import com.splunk.ServiceArgs;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Collection;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RestTransport<T>
extends AbstractTransport<T> {
    private static final Logger LOGGER = LogManager.getLogger(RestTransport.class);
    private static final int TOKEN_EXPIRATION_MS = 3300000;
    private long lastConnection;
    private Service service;
    private Index index;
    private RestTransportConfig config;

    public RestTransport(RestTransportConfig config, ObjectMapper objectMapper) {
        super(objectMapper);
        this.config = config;
    }

    @Override
    public void init() throws InitializationException {
        try {
            LOGGER.debug("Connecting to the Splunk server: {}:{}.", (Object)this.config.getHost(), (Object)this.config.getPort());
            ServiceArgs loginArgs = new ServiceArgs();
            loginArgs.setUsername(this.config.getUser());
            loginArgs.setPassword(this.config.getPass());
            loginArgs.setHost(this.config.getHost());
            loginArgs.setPort(this.config.getPort());
            loginArgs.setScheme(this.config.getScheme().getValue());
            if (this.config.getScheme().equals((Object)HttpScheme.HTTPS)) {
                SSLSecurityProtocol protocol = this.config.getSslSecurityProtocol();
                Service.setSslSecurityProtocol((SSLSecurityProtocol)protocol);
            }
            this.service = Service.connect((Map)loginArgs);
            this.lastConnection = System.currentTimeMillis();
            LOGGER.debug("Successfully connected to the Splunk server.");
        }
        catch (Exception e) {
            throw new InitializationException("There was an error connecting to the Splunk server. Please review your settings.", e);
        }
        try {
            LOGGER.debug("Retrieving the Splunk index: {}", (Object)this.config.getIndex());
            this.index = (Index)this.service.getIndexes().get((Object)this.config.getIndex());
            if (this.index == null) {
                LOGGER.warn("Creating the index: {}", (Object)this.config.getIndex());
                this.index = (Index)this.service.getIndexes().create(this.config.getIndex());
                if (this.index == null) {
                    throw new InitializationException(String.format("Couldn't create the Splunk index: {}", this.config.getIndex()));
                }
                LOGGER.debug("Splunk index: {}, created successfully.", (Object)this.config.getIndex());
            }
        }
        catch (Exception e) {
            throw new InitializationException("There was an error obtaining the Splunk index.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean send(Collection<T> messages) {
        boolean bl;
        Socket socket;
        block15: {
            if (this.service == null || this.index == null) {
                LOGGER.debug("The Splunk service isn't initializated correctly.");
                return false;
            }
            if (System.currentTimeMillis() - this.lastConnection >= 3300000L) {
                LOGGER.info("Refreshing the session token.");
                this.service.login();
            }
            socket = null;
            OutputStream output = null;
            try {
                Args args = new Args();
                args.put((Object)"source", (Object)this.config.getSource());
                args.put((Object)"sourcetype", (Object)this.config.getSourceType());
                socket = this.index.attach(args);
                output = socket.getOutputStream();
                for (T message : messages) {
                    this.serializeTo(message, output);
                }
                this.lastConnection = System.currentTimeMillis();
                bl = true;
                if (output == null) break block15;
            }
            catch (IOException e) {
                boolean bl2;
                block16: {
                    try {
                        LOGGER.error("There was an error sending the notifications to the Splunk instance.", (Throwable)e);
                        bl2 = false;
                        if (output == null) break block16;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (output != null) {
                                output.close();
                            }
                            if (socket != null) {
                                socket.close();
                            }
                            throw throwable;
                        }
                        catch (IOException e2) {
                            LOGGER.error("There was an error closing the communication to the Splunk instance.", (Throwable)e2);
                            return false;
                        }
                    }
                    output.close();
                }
                if (socket != null) {
                    socket.close();
                }
                return bl2;
            }
            output.close();
        }
        if (socket != null) {
            socket.close();
        }
        return bl;
    }

    @Override
    public void dispose() {
        if (this.service != null) {
            this.service.logout();
        }
    }
}

