/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.common.internalhandler.splunk.transport.AbstractTransport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.HECTransportConfig;
import com.mulesoft.agent.handlers.exception.InitializationException;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.asynchttpclient.AsyncHttpClientConfig;
import org.asynchttpclient.BoundRequestBuilder;
import org.asynchttpclient.DefaultAsyncHttpClient;
import org.asynchttpclient.DefaultAsyncHttpClientConfig;
import org.asynchttpclient.Response;

public class HECTransport<T>
extends AbstractTransport<T> {
    private static final Logger LOGGER = LogManager.getLogger(HECTransport.class);
    private static final int CONNECTION_TIMEOUT = 10000;
    private static final String HEC_PATH = "/services/collector";
    private HECTransportConfig config;
    private String host;
    private URL url;

    public HECTransport(HECTransportConfig config, ObjectMapper objectMapper) {
        super(objectMapper);
        this.config = config;
    }

    @Override
    public void init() throws InitializationException {
        try {
            this.url = new URL(this.config.getScheme().getValue(), this.config.getHost(), this.config.getPort(), HEC_PATH);
            LOGGER.debug("Connecting to the Splunk server: %s:%s.", (Object)this.config.getHost(), (Object)this.config.getPort());
            try (Socket socket = new Socket();){
                socket.connect(new InetSocketAddress(this.config.getHost(), this.config.getPort()), 10000);
            }
            LOGGER.debug("Successfully connected to the Splunk server.");
            if (this.host == null) {
                try {
                    this.host = InetAddress.getLocalHost().toString();
                }
                catch (UnknownHostException e) {
                    LOGGER.warn("The host couldn't be calculated.", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            throw new InitializationException("There was an error connecting to the Splunk server. Please review your settings.", e);
        }
    }

    @Override
    public boolean send(Collection<T> messages) {
        try {
            Response response;
            StringBuilder sb = new StringBuilder();
            for (T message : messages) {
                HECMessage<T> wrappedMessage = new HECMessage<T>(message, this.config.getSource(), this.config.getSourceType(), this.config.getIndex(), this.host);
                String serialized = this.serialize(wrappedMessage);
                if (!StringUtils.isNotBlank((String)serialized)) continue;
                sb.append(serialized);
            }
            DefaultAsyncHttpClientConfig httpClientConfig = new DefaultAsyncHttpClientConfig.Builder().setThreadPoolName("HECTransport_AsyncHttpClient").addChannelOption(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT).setUseInsecureTrustManager(this.config.getAcceptAnyCertificate().booleanValue()).build();
            try (DefaultAsyncHttpClient asyncHttpClient = new DefaultAsyncHttpClient((AsyncHttpClientConfig)httpClientConfig);){
                response = (Response)((BoundRequestBuilder)((BoundRequestBuilder)asyncHttpClient.preparePost(this.url.toString()).addHeader((CharSequence)"Authorization", "Splunk " + this.config.getToken())).setBody(sb.toString())).execute().get();
            }
            if (response.getStatusCode() != 200) {
                LOGGER.error("The Splunk server didn't accept the request. Sending {} events. Error: {} - {}", (Object)messages.size(), (Object)response.getStatusCode(), (Object)response.getStatusText());
                return false;
            }
            return true;
        }
        catch (InterruptedException e) {
            LOGGER.error("There was an error retrieving the response.", (Throwable)e);
            return false;
        }
        catch (ExecutionException e) {
            LOGGER.error("There was an error executing the request.", (Throwable)e);
            return false;
        }
        catch (IOException e) {
            LOGGER.error("There was an error executing the request.", (Throwable)e);
            return false;
        }
    }

    @Override
    public void dispose() {
    }

    static class HECMessage<T> {
        @JsonProperty(value="host")
        private String host;
        @JsonProperty(value="source")
        private String source;
        @JsonProperty(value="sourcetype")
        private String sourceType;
        @JsonProperty(value="index")
        private String index;
        @JsonProperty(value="event")
        private T event;

        HECMessage(T event, String source, String sourceType, String index, String host) {
            this.event = event;
            this.source = source;
            this.sourceType = sourceType;
            this.index = index;
            this.host = host;
        }

        public String toString() {
            return "HECMessage{host='" + this.host + '\'' + ", source='" + this.source + '\'' + ", sourceType='" + this.sourceType + '\'' + ", index='" + this.index + '\'' + ", event=" + this.event + '}';
        }
    }
}

