/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport;

import com.mulesoft.agent.common.internalhandler.AbstractSplunkInternalHandler;
import com.mulesoft.agent.common.internalhandler.splunk.transport.HECTransport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.RestTransport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.TCPTransport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.Transport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.TransportFactory;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.HECTransportConfig;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.RestTransportConfig;
import com.mulesoft.agent.common.internalhandler.splunk.transport.config.TCPTransportConfig;
import com.mulesoft.agent.exception.AgentConfigurationException;
import java.io.Serializable;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DefaultTransportFactory<T extends Serializable>
implements TransportFactory<T> {
    private static final Logger LOGGER = LogManager.getLogger(DefaultTransportFactory.class);
    private final AbstractSplunkInternalHandler<T> internalHandler;

    public DefaultTransportFactory(AbstractSplunkInternalHandler<T> internalHandler) {
        this.internalHandler = internalHandler;
    }

    @Override
    public Transport<T> create() throws AgentConfigurationException {
        if (StringUtils.isNotBlank((String)this.internalHandler.getToken())) {
            HECTransportConfig config = new HECTransportConfig.Builder(this.internalHandler).build();
            LOGGER.debug("Creating the a HECTransport with the settings: " + config);
            return new HECTransport(config, this.internalHandler.getObjectMapper());
        }
        if (this.internalHandler.getScheme().equals("tcp")) {
            TCPTransportConfig config = new TCPTransportConfig.Builder(this.internalHandler).build();
            LOGGER.debug("Creating the a TCPTransport with the settings: " + config);
            return new TCPTransport(config, this.internalHandler.getObjectMapper());
        }
        RestTransportConfig config = new RestTransportConfig.Builder(this.internalHandler).build();
        LOGGER.debug("Creating the a RestTransport with the settings: " + config);
        return new RestTransport(config, this.internalHandler.getObjectMapper());
    }
}

