/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler.splunk.transport;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.common.internalhandler.splunk.transport.Transport;
import java.io.OutputStream;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractTransport<T>
implements Transport<T> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractTransport.class);
    protected static final String CHARSET = "UTF-8";
    protected static final String LINE_BREAKER = "\r\n";
    private final ObjectMapper objectMapper;

    protected AbstractTransport(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    protected String serialize(Object message) {
        try {
            return this.objectMapper.writeValueAsString(message) + LINE_BREAKER;
        }
        catch (Throwable t) {
            LOGGER.warn("Couldn't serialize the message, discarding it. Error: {}", (Object)ExceptionUtils.getRootCauseMessage((Throwable)t));
            LOGGER.debug("Message: {}", message);
            LOGGER.debug("Exception: ", t);
            return null;
        }
    }

    protected void serializeTo(T message, OutputStream outputStream) {
        try {
            String serializer = this.serialize(message);
            if (StringUtils.isNotBlank((String)serializer)) {
                outputStream.write(serializer.getBytes(CHARSET));
                outputStream.flush();
            }
        }
        catch (Throwable t) {
            LOGGER.warn("Couldn't write the message: {} to the output stream, discarding it. Error: {}", message, (Object)t.getMessage());
            LOGGER.debug("Exception: ", t);
        }
    }
}

