/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferExhaustedAction;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.common.internalhandler.serializer.DefaultObjectMapperFactory;
import com.mulesoft.agent.common.internalhandler.splunk.transport.DefaultTransportFactory;
import com.mulesoft.agent.common.internalhandler.splunk.transport.Transport;
import com.mulesoft.agent.common.internalhandler.splunk.transport.TransportFactory;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Password;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.exception.AgentConfigurationException;
import com.mulesoft.agent.handlers.exception.InitializationException;
import java.io.Serializable;
import java.util.Collection;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractSplunkInternalHandler<T extends Serializable>
extends BufferedHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int DEFAULT_BUFFER_RETRY_COUNT = 3;
    private static final long DEFAULT_BUFFER_FLUSH_FREQUENCY = 10000L;
    private static final int DEFAULT_BUFFER_MAXIMUM_CAPACITY = 1000;
    private static final boolean DEFAULT_DISCARD_ON_FAILURE = false;
    private TransportFactory<T> transportFactory = new DefaultTransportFactory(this);
    private ObjectMapper objectMapper;
    private Transport<T> transport;
    @Configurable(type=Type.DYNAMIC)
    private String user;
    @Password
    @Configurable(type=Type.DYNAMIC)
    private String pass;
    @Password
    @Configurable(type=Type.DYNAMIC)
    private String token;
    @Configurable(type=Type.DYNAMIC)
    private String host;
    @Configurable(value="8089", type=Type.DYNAMIC)
    private int port;
    @Configurable(value="https", type=Type.DYNAMIC)
    private String scheme;
    @Configurable(value="TLSv1_2", type=Type.DYNAMIC)
    private String sslSecurityProtocol;
    @Configurable(value="main", type=Type.DYNAMIC)
    private String splunkIndexName;
    @Configurable(value="mule", type=Type.DYNAMIC)
    private String splunkSource;
    @Configurable(value="mule", type=Type.DYNAMIC)
    private String splunkSourceType;
    @Configurable(value="yyyy-MM-dd'T'HH:mm:ss.SZ", type=Type.DYNAMIC)
    private String dateFormatPattern;
    @Configurable(value="true", type=Type.DYNAMIC)
    private Boolean acceptAnyCertificate;

    protected boolean canHandle(T message) {
        return true;
    }

    protected boolean flush(Collection<T> messages) {
        LOGGER.debug("Flushing {} notifications.", (Object)messages.size());
        if (this.transport == null) {
            throw new NullPointerException("The Splunk transport isn't initialized.");
        }
        boolean succeeded = this.transport.send(messages);
        if (succeeded) {
            LOGGER.debug("Flushed {} notifications.", (Object)messages.size());
        }
        return succeeded;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void initialize() throws InitializationException {
        LOGGER.debug("Configuring the Splunk Internal Handler with values: {}", (Object)this);
        this.acceptAnyCertificate = this.acceptAnyCertificate == null ? true : this.acceptAnyCertificate;
        if (this.transport != null) {
            LOGGER.debug("Disposing the previous Splunk transport");
            this.transport.dispose();
        }
        if (this.objectMapper == null) {
            this.objectMapper = new DefaultObjectMapperFactory(this.dateFormatPattern).create();
        }
        try {
            LOGGER.debug("Creating a new Splunk transport");
            this.transport = this.transportFactory.create();
            LOGGER.debug("Initializing the Splunk transport: {}", this.transport);
            this.transport.init();
        }
        catch (AgentConfigurationException e) {
            throw new InitializationException("There was an error configuring the Internal Handler", (Exception)((Object)e));
        }
        LOGGER.debug("Successfully configured the Common Splunk Internal Handler.");
        super.initialize();
    }

    public BufferConfiguration getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        BufferConfiguration defaultBuffer = new BufferConfiguration();
        defaultBuffer.setType(BufferType.MEMORY);
        defaultBuffer.setRetryCount(Integer.valueOf(3));
        defaultBuffer.setFlushFrequency(Long.valueOf(10000L));
        defaultBuffer.setMaximumCapacity(Integer.valueOf(1000));
        defaultBuffer.setDiscardMessagesOnFlushFailure(false);
        defaultBuffer.setWhenExhausted(BufferExhaustedAction.FLUSH);
        return defaultBuffer;
    }

    public void setTransportFactory(TransportFactory<T> transportFactory) {
        this.transportFactory = transportFactory;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public void setTransport(Transport<T> transport) {
        this.transport = transport;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setSslSecurityProtocol(String sslSecurityProtocol) {
        this.sslSecurityProtocol = sslSecurityProtocol;
    }

    public void setSplunkIndexName(String splunkIndexName) {
        this.splunkIndexName = splunkIndexName;
    }

    public void setSplunkSource(String splunkSource) {
        this.splunkSource = splunkSource;
    }

    public void setSplunkSourceType(String splunkSourceType) {
        this.splunkSourceType = splunkSourceType;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }

    public void setAcceptAnyCertificate(Boolean acceptAnyCertificate) {
        this.acceptAnyCertificate = acceptAnyCertificate;
    }

    public TransportFactory<T> getTransportFactory() {
        return this.transportFactory;
    }

    public Transport<T> getTransport() {
        return this.transport;
    }

    public String getUser() {
        return this.user;
    }

    public String getPass() {
        return this.pass;
    }

    public String getToken() {
        return this.token;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getSslSecurityProtocol() {
        return this.sslSecurityProtocol;
    }

    public String getSplunkIndexName() {
        return this.splunkIndexName;
    }

    public String getSplunkSource() {
        return this.splunkSource;
    }

    public String getSplunkSourceType() {
        return this.splunkSourceType;
    }

    public String getDateFormatPattern() {
        return this.dateFormatPattern;
    }

    public Boolean getAcceptAnyCertificate() {
        return this.acceptAnyCertificate;
    }

    public String toString() {
        return "AbstractSplunkInternalHandler{user='" + this.user + '\'' + ", host='" + this.host + '\'' + ", token='" + this.token + '\'' + ", port=" + this.port + ", scheme='" + this.scheme + '\'' + ", sslSecurityProtocol='" + this.sslSecurityProtocol + '\'' + ", splunkIndexName='" + this.splunkIndexName + '\'' + ", splunkSource='" + this.splunkSource + '\'' + ", splunkSourceType='" + this.splunkSourceType + '\'' + ", dateFormatPattern='" + this.dateFormatPattern + '\'' + '}';
    }
}

