/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferExhaustedAction;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.common.internalhandler.serializer.DefaultObjectMapperFactory;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.handlers.exception.InitializationException;
import com.mulesoft.agent.services.OnOffSwitch;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.Collection;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.RollingRandomAccessFileAppender;
import org.apache.logging.log4j.core.appender.rolling.CompositeTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.SizeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TimeBasedTriggeringPolicy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.layout.PatternLayout;

public abstract class AbstractLogInternalHandler<T extends Serializable>
extends BufferedHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractLogInternalHandler.class);
    public static final String MULE_HOME_PLACEHOLDER = "$MULE_HOME";
    public static final String PATTERN_LAYOUT = "%m%n";
    public static final int MB_CONVERSION_UNIT = 1024;
    private static final int DEFAULT_BUFFER_RETRY_COUNT = 3;
    private static final long DEFAULT_BUFFER_FLUSH_FREQUENCY = 10000L;
    private static final int DEFAULT_BUFFER_MAXIMUM_CAPACITY = 1000;
    private static final boolean DEFAULT_DISCARD_ON_FAILURE = false;
    private String className = ((Object)((Object)this)).getClass().getName();
    private String loggerName = this.className + ".logger";
    private String appenderName = this.className + ".appender";
    private String contextName = this.className + ".context";
    private Configuration logConfiguration;
    private LoggerConfig loggerConfig;
    private Appender appender;
    private LoggerContext logContext;
    private ObjectMapper objectMapper;
    org.apache.logging.log4j.core.Logger internalLogger;
    OnOffSwitch enabledSwitch;
    @Configurable(value="false")
    private boolean enabled;
    @Configurable(value="262144", type=Type.DYNAMIC)
    private int bufferSize;
    @Configurable(value="true", type=Type.DYNAMIC)
    private boolean immediateFlush;
    @Configurable(value="1", type=Type.DYNAMIC)
    private int daysTrigger;
    @Configurable(value="100", type=Type.DYNAMIC)
    private int mbTrigger;
    @Configurable(value="yyyy-MM-dd'T'HH:mm:ss.SZ", type=Type.DYNAMIC)
    private String dateFormatPattern;

    protected abstract String getFileName();

    protected abstract String getFilePattern();

    protected ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    protected boolean canHandle(T message) {
        return true;
    }

    protected boolean flush(Collection<T> collection) {
        try {
            for (Serializable message : collection) {
                this.internalLogger.info(this.objectMapper.writeValueAsString((Object)message));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("There was an error logging the object.", (Throwable)e);
            return false;
        }
    }

    public BufferConfiguration getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        BufferConfiguration defaultBuffer = new BufferConfiguration();
        defaultBuffer.setType(BufferType.MEMORY);
        defaultBuffer.setRetryCount(Integer.valueOf(3));
        defaultBuffer.setFlushFrequency(Long.valueOf(10000L));
        defaultBuffer.setMaximumCapacity(Integer.valueOf(1000));
        defaultBuffer.setDiscardMessagesOnFlushFailure(false);
        defaultBuffer.setWhenExhausted(BufferExhaustedAction.FLUSH);
        return defaultBuffer;
    }

    public void initialize() throws InitializationException {
        LOGGER.debug("Configuring the Common Log Internal Handler...");
        super.initialize();
        if (this.logContext != null) {
            this.appender.stop();
            this.loggerConfig.removeAppender(this.appenderName);
            this.logConfiguration.removeLogger(this.loggerName);
        }
        try {
            this.logContext = new LoggerContext(this.contextName);
            this.logConfiguration = this.logContext.getConfiguration();
            PatternLayout layout = PatternLayout.newBuilder().withPattern(PATTERN_LAYOUT).withCharset(Charset.forName("UTF-8")).withAlwaysWriteExceptions(true).withNoConsoleNoAnsi(false).build();
            String dayTrigger = this.daysTrigger + "";
            String sizeTrigger = this.mbTrigger * 1024 * 1024 + "";
            TimeBasedTriggeringPolicy timeBasedTriggeringPolicy = TimeBasedTriggeringPolicy.createPolicy((String)dayTrigger, (String)"true");
            SizeBasedTriggeringPolicy sizeBasedTriggeringPolicy = SizeBasedTriggeringPolicy.createPolicy((String)sizeTrigger);
            CompositeTriggeringPolicy policy = CompositeTriggeringPolicy.createPolicy((TriggeringPolicy[])new TriggeringPolicy[]{timeBasedTriggeringPolicy, sizeBasedTriggeringPolicy});
            String fileName = this.getFileName().replace(MULE_HOME_PLACEHOLDER, System.getProperty("mule.home"));
            String filePattern = this.getFilePattern().replace(MULE_HOME_PLACEHOLDER, System.getProperty("mule.home"));
            this.appender = RollingRandomAccessFileAppender.createAppender((String)fileName, (String)filePattern, (String)"true", (String)this.appenderName, (String)(this.immediateFlush + ""), (String)(this.bufferSize + ""), (TriggeringPolicy)policy, null, (Layout)layout, null, (String)"false", null, null, (Configuration)this.logConfiguration);
            this.appender.start();
            AppenderRef[] ref = new AppenderRef[]{};
            this.loggerConfig = LoggerConfig.createLogger((String)"false", (Level)Level.INFO, (String)this.loggerName, (String)"false", (AppenderRef[])ref, null, (Configuration)this.logConfiguration, null);
            this.loggerConfig.addAppender(this.appender, null, null);
            this.logConfiguration.addLogger(this.loggerName, this.loggerConfig);
            this.internalLogger = this.logContext.getLogger(this.loggerName);
        }
        catch (Exception e) {
            throw new InitializationException("There was an error configuring the AbstractLogInternalHandler internal handler.", e);
        }
        this.objectMapper = new DefaultObjectMapperFactory(this.dateFormatPattern).create();
        LOGGER.debug("Successfully configured the Common Log Internal Handler.");
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setImmediateFlush(boolean immediateFlush) {
        this.immediateFlush = immediateFlush;
    }

    public void setDaysTrigger(int daysTrigger) {
        this.daysTrigger = daysTrigger;
    }

    public void setMbTrigger(int mbTrigger) {
        this.mbTrigger = mbTrigger;
    }

    public void setDateFormatPattern(String dateFormatPattern) {
        this.dateFormatPattern = dateFormatPattern;
    }
}

