/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.common.internalhandler;

import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferExhaustedAction;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Password;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.handlers.exception.InitializationException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractDBInternalHandler<T extends Serializable>
extends BufferedHandler<T> {
    private static final Logger LOGGER = LogManager.getLogger(AbstractDBInternalHandler.class);
    private static final int DEFAULT_BUFFER_RETRY_COUNT = 3;
    private static final long DEFAULT_BUFFER_FLUSH_FREQUENCY = 10000L;
    private static final int DEFAULT_BUFFER_MAXIMUM_CAPACITY = 1000;
    private static final boolean DEFAULT_BUFFER_DISCARD_MESSAGES_ON_FLUSH_FAILURE = false;
    @Configurable(type=Type.DYNAMIC)
    String driver;
    @Configurable(type=Type.DYNAMIC)
    String jdbcUrl;
    @Configurable(type=Type.DYNAMIC)
    String user;
    @Password
    @Configurable(type=Type.DYNAMIC)
    String pass;

    protected abstract void insert(Connection var1, Collection<T> var2) throws SQLException;

    protected boolean canHandle(T message) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean flush(Collection<T> messages) {
        LOGGER.debug(String.format("Flushing %s messages.", messages.size()));
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(this.jdbcUrl, this.user, this.pass);
            connection.setAutoCommit(false);
            try {
                this.insert(connection, messages);
                connection.commit();
            }
            catch (Exception ex) {
                LOGGER.error("There was an error inserting the messages. Rolling back the transaction.", (Throwable)ex);
                try {
                    connection.rollback();
                }
                catch (SQLException sqlEx) {
                    LOGGER.error("There was an error while rolling back the transaction.", (Throwable)sqlEx);
                }
            }
            boolean ex = true;
            return ex;
        }
        catch (Throwable e) {
            LOGGER.error("Couldn't insert the tracking notifications.", e);
            boolean bl = false;
            return bl;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException e) {
                    LOGGER.error("Error closing the database.", (Throwable)e);
                }
            }
        }
    }

    public void initialize() throws InitializationException {
        LOGGER.debug("Configuring the Common DB Internal Handler...");
        if (StringUtils.isEmpty((String)this.driver) || StringUtils.isEmpty((String)this.jdbcUrl)) {
            throw new InitializationException("Please review configuration; you must configure the following properties: driver and jdbcUrl.");
        }
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new InitializationException(String.format("Couldn't load the database driver '%s'. Did you copy the JAR driver to the {MULE_HOME}/plugins/mule-agent-plugin/lib?", this.driver), (Exception)e);
        }
        try {
            LOGGER.debug("Testing database connection...");
            DriverManager.getConnection(this.jdbcUrl, this.user, this.pass).close();
            LOGGER.debug("Database connection OK!.");
        }
        catch (SQLException e) {
            throw new InitializationException("There was an error on the connection to the DataBase. Please review your agent configuration.", (Exception)e);
        }
        LOGGER.debug("Successfully configured the Common DB Internal Handler.");
        super.initialize();
    }

    public BufferConfiguration getBuffer() {
        if (this.buffer != null) {
            return this.buffer;
        }
        BufferConfiguration defaultBuffer = new BufferConfiguration();
        defaultBuffer.setType(BufferType.MEMORY);
        defaultBuffer.setRetryCount(Integer.valueOf(3));
        defaultBuffer.setFlushFrequency(Long.valueOf(10000L));
        defaultBuffer.setMaximumCapacity(Integer.valueOf(1000));
        defaultBuffer.setDiscardMessagesOnFlushFailure(false);
        defaultBuffer.setWhenExhausted(BufferExhaustedAction.FLUSH);
        return defaultBuffer;
    }

    public String getDriver() {
        return this.driver;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public String getJdbcUrl() {
        return this.jdbcUrl;
    }

    public void setJdbcUrl(String jdbcUrl) {
        this.jdbcUrl = jdbcUrl;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPass() {
        return this.pass;
    }

    public void setPass(String pass) {
        this.pass = pass;
    }
}

