/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.eventtracker.analytics;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.google.common.collect.Lists;
import com.mulesoft.agent.buffer.BufferConfiguration;
import com.mulesoft.agent.buffer.BufferType;
import com.mulesoft.agent.buffer.BufferedHandler;
import com.mulesoft.agent.clients.AuthenticationProxyClient;
import com.mulesoft.agent.clients.AuthenticationProxyFactory;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.NotAvailableOn;
import com.mulesoft.agent.configuration.common.AuthenticationProxyConfiguration;
import com.mulesoft.agent.domain.RuntimeEnvironment;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.eventtracker.analytics.AnalyticsEventSerializer;
import com.mulesoft.agent.handlers.exception.InitializationException;
import com.mulesoft.agent.handlers.internal.buffer.DiscardingMessageBufferConfigurationFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Singleton
@Named(value="mule.agent.tracking.handler.analytics")
@NotAvailableOn(environment={RuntimeEnvironment.ON_PREM, RuntimeEnvironment.STANDALONE})
public class EventTrackingAnalyticsInternalHandler
extends BufferedHandler<AgentTrackingNotification> {
    private static final Logger LOGGER = LogManager.getLogger(EventTrackingAnalyticsInternalHandler.class);
    private static final long FLUSH_FREQUENCY = 10000L;
    private static final int MAXIMUM_CAPACITY = 5000;
    private ObjectMapper objectMapper;
    @Inject
    private AuthenticationProxyFactory authenticationProxyFactory;
    @Configurable(value="{}")
    private AuthenticationProxyConfiguration authenticationProxy;
    @Configurable(value="true")
    boolean enabled;
    private AuthenticationProxyClient authProxyClient;

    public void initialize() throws InitializationException {
        super.initialize();
        this.authProxyClient = this.authenticationProxyFactory.create(this.authenticationProxy, this.getMapper());
    }

    protected boolean canHandle(AgentTrackingNotification agentTrackingNotification) {
        return true;
    }

    protected boolean flush(Collection<AgentTrackingNotification> notifications) {
        try {
            boolean fullSuccess = true;
            Collection<List<AgentTrackingNotification>> groupedNotifications = this.groupByApplication(notifications);
            for (List<AgentTrackingNotification> applicationNotifications : groupedNotifications) {
                String applicationName = applicationNotifications.get(0).getApplication();
                HashMap<String, ArrayList> headers = new HashMap<String, ArrayList>();
                headers.put("X-APPLICATION-NAME", Lists.newArrayList((Object[])new String[]{applicationName}));
                try {
                    this.authProxyClient.put("/insight/ingest/api/v1/", applicationNotifications, headers);
                }
                catch (Exception e) {
                    fullSuccess = false;
                    LOGGER.warn("Could not send tracking event to the Analytics service for application " + applicationName);
                    LOGGER.debug("Could not send tracking event to the Analytics service for application " + applicationName, (Throwable)e);
                }
            }
            return fullSuccess;
        }
        catch (Exception e) {
            LOGGER.warn("Could not send tracking event to the Analytics service");
            LOGGER.debug("Could not send tracking event to the Analytics service", (Throwable)e);
            return false;
        }
    }

    public BufferConfiguration getBuffer() {
        if (this.buffer == null) {
            this.buffer = new DiscardingMessageBufferConfigurationFactory().create(10000L, 5000, BufferType.MEMORY, null);
        }
        return this.buffer;
    }

    private Collection<List<AgentTrackingNotification>> groupByApplication(Collection<AgentTrackingNotification> events) {
        HashMap groupedEvents = new HashMap();
        for (AgentTrackingNotification event : events) {
            if (!groupedEvents.containsKey(event.getApplication())) {
                groupedEvents.put(event.getApplication(), new LinkedList());
            }
            ((List)groupedEvents.get(event.getApplication())).add(event);
        }
        return groupedEvents.values();
    }

    private ObjectMapper getMapper() {
        if (this.objectMapper == null) {
            this.objectMapper = new ObjectMapper();
            SimpleModule serializationModule = new SimpleModule("SerializationModule", new Version(1, 0, 0, null, null, null));
            serializationModule.addSerializer((JsonSerializer)new AnalyticsEventSerializer());
            this.objectMapper.registerModule((Module)serializationModule);
        }
        return this.objectMapper;
    }
}

