/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.eventtracker.analytics;

import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;

public enum AnalyticsEventType {
    PROCESS_ASYNC_SCHEDULED("AsyncMessageNotification", "async process scheduled"),
    PROCESS_ASYNC_COMPLETE("AsyncMessageNotification", "async process complete"),
    COMPONENT_PRE_INVOKE("ComponentMessageNotification", "component pre invoke"),
    COMPONENT_POST_INVOKE("ComponentMessageNotification", "component post invoke"),
    MESSAGE_RECEIVE("EndpointMessageNotification", "receive"),
    MESSAGE_RESPONSE("EndpointMessageNotification", "response"),
    MESSAGE_DISPATCH_BEGIN("EndpointMessageNotification", "begin dispatch"),
    MESSAGE_DISPATCH_END("EndpointMessageNotification", "end dispatch"),
    MESSAGE_SEND_BEGIN("EndpointMessageNotification", "begin send"),
    MESSAGE_SEND_END("EndpointMessageNotification", "end send"),
    MESSAGE_REQUEST_BEGIN("EndpointMessageNotification", "begin request"),
    MESSAGE_REQUEST_END("EndpointMessageNotification", "end request"),
    EXCEPTION_PROCESS_START("ErrorHandlerNotification", "exception strategy process start"),
    EXCEPTION_PROCESS_END("ErrorHandlerNotification", "exception strategy process end"),
    MESSAGE_PROCESSOR_PRE_INVOKE("MessageProcessorNotification", "message processor pre invoke"),
    MESSAGE_PROCESSOR_POST_INVOKE("MessageProcessorNotification", "message processor post invoke"),
    PROCESS_START("PipelineMessageNotification", "pipeline process start"),
    PROCESS_COMPLETE("PipelineMessageNotification", "pipeline process complete"),
    PROCESS_END("PipelineMessageNotification", "pipeline request message processing end"),
    TRANSACTION_BEGAN("TransactionNotification", "begin"),
    TRANSACTION_COMMITTED("TransactionNotification", "commit"),
    TRANSACTION_ROLLEDBACK("TransactionNotification", "rollback"),
    CUSTOM_EVENT_EVENT_ACTION("EventNotification", "custom event"),
    EXCEPTION_ACTION("ExceptionNotification", "exception"),
    UNKNOWN("Unknown", "Unknown");

    private String notificationType;
    private String action;

    private AnalyticsEventType(String notificationType, String action) {
        this.notificationType = notificationType;
        this.action = action;
    }

    public static AnalyticsEventType getAnalyticsEventType(AgentTrackingNotification notification) {
        String notificationType = notification.getNotificationType();
        String action = notification.getAction();
        for (AnalyticsEventType type : AnalyticsEventType.values()) {
            if (!type.notificationType.equals(notificationType) || !type.action.equals(action)) continue;
            return type;
        }
        return UNKNOWN;
    }
}

