/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.eventtracker.analytics;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.eventtracker.analytics.AnalyticsEventType;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.tooling.event.model.component.location.ComponentLocation;

public class AnalyticsEventSerializer
extends JsonSerializer<AgentTrackingNotification> {
    private static final Logger LOGGER = LogManager.getLogger(AnalyticsEventSerializer.class);

    public Class<AgentTrackingNotification> handledType() {
        return AgentTrackingNotification.class;
    }

    public void serialize(AgentTrackingNotification value, JsonGenerator jgen, SerializerProvider provider) throws IOException {
        AnalyticsEventType analyticsEventType = AnalyticsEventType.getAnalyticsEventType(value);
        if (analyticsEventType.equals((Object)AnalyticsEventType.UNKNOWN)) {
            LOGGER.debug("Skipping serialization of notification with UNKNOWN type from application {}.", (Object)value.getApplication());
            return;
        }
        jgen.writeStartObject();
        jgen.writeStringField("id", this.getId());
        jgen.writeStringField("messageId", value.getCorrelationId());
        jgen.writeStringField("name", Optional.ofNullable(value.getCustomEventName()).orElse(""));
        jgen.writeStringField("type", analyticsEventType.name());
        jgen.writeNumberField("timestamp", value.getTimestamp());
        jgen.writeStringField("flowName", Optional.ofNullable(value.getResourceIdentifier()).orElse(""));
        jgen.writeStringField("path", Optional.ofNullable(value.getComponentLocation()).map(ComponentLocation::getLocation).orElse(""));
        jgen.writeFieldName("customProperties");
        jgen.writeStartObject();
        if (value.getCustomEventProperties() != null) {
            for (Map.Entry property : value.getCustomEventProperties().entrySet()) {
                jgen.writeStringField((String)property.getKey(), (String)property.getValue());
            }
        }
        jgen.writeEndObject();
        jgen.writeFieldName("systemProperties");
        jgen.writeStartObject();
        if (value.getNotificationType().equals("ExceptionNotification")) {
            jgen.writeStringField("EXCEPTION_DETAILS", value.getSource());
        }
        if (value.getNotificationType().equals("ComponentNotification")) {
            jgen.writeStringField("COMPONENT_CLASS", value.getSource());
        }
        if (value.getCorrelationId() != null) {
            jgen.writeStringField("MESSAGE_CORRELATION_ID", value.getCorrelationId());
        }
        if (value.getTrackingTransactionId() != null) {
            jgen.writeStringField("CUSTOM_TRANSACTION_ID", value.getTrackingTransactionId());
        }
        jgen.writeEndObject();
        jgen.writeEndObject();
    }

    protected String getId() {
        return UUID.randomUUID().toString();
    }
}

