/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.dataweave;

import com.mulesoft.agent.domain.tooling.dataweave.model.DataWeaveExecutionException;
import com.mulesoft.agent.domain.tooling.dataweave.model.Event;
import com.mulesoft.agent.domain.tooling.dataweave.model.Message;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;
import com.mulesoft.agent.services.RuntimeVersionService;
import com.mulesoft.agent.services.dataweave.DataWeaveExecutor;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.io.IOUtils;
import org.mule.runtime.api.el.BindingContext;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.ItemSequenceInfo;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.metadata.DataType;
import org.mule.runtime.api.metadata.TypedValue;
import org.mule.runtime.api.security.Authentication;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.api.streaming.bytes.CursorStreamProvider;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.el.ExpressionManagerSession;
import org.mule.runtime.core.api.expression.ExpressionRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="default-dw-executor")
public class DefaultDataWeaveExecutor
implements DataWeaveExecutor {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultDataWeaveExecutor.class);
    private static final String DEFAULT_ATTRIBUTES_MEDIA_TYPE = "application/java";
    public static final String DW_TRANSFORMATION = "output application/dw\n---\npayload";
    private static final DataType VARS_DATA_TYPE = DataType.builder().mapType(Map.class).keyType(String.class).valueType(TypedValue.class).build();
    private static final DataType MESAGE_DATA_TYPE = DataType.fromType(org.mule.runtime.api.message.Message.class);
    private static final TypedValue EMPTY_VARS = new TypedValue(Collections.emptyMap(), VARS_DATA_TYPE);
    private static final Supplier<TypedValue> EMPTY_VARS_SUPPLIER = () -> EMPTY_VARS;
    private static final TypedValue NULL_TYPED_VALUE = new TypedValue(null, DataType.OBJECT);
    private static final Supplier<TypedValue> NULL_TYPED_VALUE_SUPPLIER = () -> NULL_TYPED_VALUE;
    @Inject
    protected RuntimeVersionService runtimeVersionService;

    @Override
    public PreviewResponse execute(PreviewRequest parameters, ExpressionManager expressionManager) {
        try {
            TypedValue<?> evaluate = this.evaluateExpression(parameters, expressionManager);
            String mediaType = evaluate.getDataType().getMediaType().withoutParameters().toRfcString();
            return new PreviewResponse.Builder().setValid(true).setResult(this.serializeResult(evaluate, expressionManager)).setMediaType(mediaType).build();
        }
        catch (ExpressionRuntimeException ex) {
            LOGGER.error("DataWeave :: Fail to execute script", (Throwable)ex);
            return new PreviewResponse.Builder().setErrorMessage(ex.getMessage()).build();
        }
        catch (Exception e) {
            LOGGER.error("DataWeave :: Error while executing script", (Throwable)e);
            throw new DataWeaveExecutionException("DataWeave :: Error while executing script", e);
        }
    }

    private TypedValue<?> evaluateExpression(PreviewRequest parameters, ExpressionManager expressionManager) throws ExpressionRuntimeException {
        BindingContext bindingContext = this.buildContextFromParameters(parameters);
        if (this.runtimeVersionService.supportsExpressionSession() && parameters.getTimeout() > 0L) {
            try (ExpressionManagerSession expressionManagerSession = expressionManager.openSession(bindingContext);){
                TypedValue typedValue = expressionManagerSession.evaluate(parameters.getScript(), parameters.getTimeout());
                return typedValue;
            }
        }
        return expressionManager.evaluate(parameters.getScript(), bindingContext);
    }

    private BindingContext buildContextFromParameters(PreviewRequest parameters) {
        BindingContext.Builder bindingBuilder = BindingContext.builder();
        bindingBuilder.addBinding("authentication", new TypedValue(null, DataType.fromType(Authentication.class)));
        bindingBuilder.addBinding("correlationId", new TypedValue(null, DataType.STRING));
        bindingBuilder.addBinding("flow", new TypedValue(null, DataType.fromType(NamedObject.class)));
        bindingBuilder.addBinding("itemSequenceInfo", new TypedValue(null, DataType.fromType(ItemSequenceInfo.class)));
        bindingBuilder.addBinding("error", new TypedValue(null, DataType.fromType(Error.class)));
        Event event = parameters.getEvent();
        if (event != null) {
            if (event.getVariables() != null && !event.getVariables().isEmpty()) {
                HashMap variables = new HashMap();
                event.getVariables().forEach((varName, value) -> variables.put(varName, this.asTypedValue((com.mulesoft.agent.domain.tooling.dataweave.model.TypedValue)value)));
                DataType variablesDataType = DataType.builder().type(Map.class).mediaType(DEFAULT_ATTRIBUTES_MEDIA_TYPE).build();
                bindingBuilder.addBinding("vars", new TypedValue(variables, variablesDataType));
            } else {
                bindingBuilder.addBinding("vars", EMPTY_VARS_SUPPLIER);
            }
            Message message = event.getMessage();
            if (message != null) {
                bindingBuilder.addBinding("message", new TypedValue((Object)new MessageWrapper(message), MESAGE_DATA_TYPE));
                if (message.getAttributes() != null) {
                    bindingBuilder.addBinding("attributes", this.asTypedValue(message.getAttributes()));
                } else {
                    bindingBuilder.addBinding("attributes", NULL_TYPED_VALUE_SUPPLIER);
                }
                if (message.getPayload() != null) {
                    bindingBuilder.addBinding("payload", this.asTypedValue(message.getPayload()));
                    bindingBuilder.addBinding("dataType", new TypedValue((Object)DataType.builder().type(String.class).mediaType(message.getPayload().getMediaType()).build(), DataType.fromType(DataType.class)));
                } else {
                    bindingBuilder.addBinding("payload", NULL_TYPED_VALUE_SUPPLIER);
                    bindingBuilder.addBinding("dataType", NULL_TYPED_VALUE_SUPPLIER);
                }
            } else {
                bindingBuilder.addBinding("attributes", NULL_TYPED_VALUE_SUPPLIER);
                bindingBuilder.addBinding("payload", NULL_TYPED_VALUE_SUPPLIER);
                bindingBuilder.addBinding("dataType", NULL_TYPED_VALUE_SUPPLIER);
            }
        } else {
            bindingBuilder.addBinding("message", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("attributes", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("payload", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("dataType", NULL_TYPED_VALUE_SUPPLIER);
            bindingBuilder.addBinding("vars", EMPTY_VARS_SUPPLIER);
        }
        return bindingBuilder.build();
    }

    private BindingContext buildCustomTransformationPayload(Object payload) {
        BindingContext.Builder bindingBuilder = BindingContext.builder();
        bindingBuilder.addBinding("payload", new TypedValue(payload, DataType.fromObject((Object)payload)));
        return bindingBuilder.build();
    }

    private String serializeResult(TypedValue result, ExpressionManager expressionManager) {
        Object value = result.getValue();
        if (value instanceof CursorStreamProvider) {
            return this.manageCursorStream((TypedValue<CursorStreamProvider>)result);
        }
        TypedValue evaluate = expressionManager.evaluate(DW_TRANSFORMATION, this.buildCustomTransformationPayload(value));
        return this.manageCursorStream((TypedValue<CursorStreamProvider>)evaluate);
    }

    private String manageCursorStream(TypedValue<CursorStreamProvider> result) {
        try (CursorStreamProvider streamProvider = null;){
            streamProvider = (CursorStreamProvider)result.getValue();
            Charset encoding = result.getDataType().getMediaType().getCharset().orElseGet(Charset::defaultCharset);
            CursorStream cursorStream = (CursorStream)streamProvider.openCursor();
            String string = IOUtils.toString((InputStream)cursorStream, (Charset)encoding);
            return string;
        }
    }

    private TypedValue asTypedValue(com.mulesoft.agent.domain.tooling.dataweave.model.TypedValue restTypedValue) {
        Object value;
        DataType dataType = DataType.builder().mediaType(restTypedValue.getMediaType()).build();
        try {
            value = Base64.getDecoder().decode(restTypedValue.getValue());
        }
        catch (IllegalArgumentException e) {
            value = restTypedValue.getValue();
        }
        return new TypedValue(value, dataType);
    }

    private class MessageWrapper
    implements org.mule.runtime.api.message.Message {
        private Message message;

        public MessageWrapper(Message message) {
            this.message = message;
        }

        public TypedValue<String> getPayload() {
            if (this.message.getPayload() != null) {
                return DefaultDataWeaveExecutor.this.asTypedValue(this.message.getPayload());
            }
            return null;
        }

        public TypedValue getAttributes() {
            if (this.message.getAttributes() != null) {
                return DefaultDataWeaveExecutor.this.asTypedValue(this.message.getAttributes());
            }
            return null;
        }

        public String toString() {
            return this.message.toString();
        }
    }
}

