/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.dataweave;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewRequest;
import com.mulesoft.agent.domain.tooling.dataweave.model.PreviewResponse;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.DataWeaveService;
import com.mulesoft.agent.services.dataweave.DataWeaveExecutor;
import java.util.List;
import java.util.function.Supplier;
import javax.inject.Named;
import javax.inject.Singleton;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.deployment.model.api.DeployableArtifact;
import org.mule.runtime.deployment.model.api.application.Application;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named(value="mule.agent.dataweave.service")
@Singleton
public class AgentDataWeaveService
extends ConfigurableAgentService
implements DataWeaveService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgentDataWeaveService.class);
    @Inject
    protected DataWeaveExecutor dataWeaveExecutor;

    public PreviewResponse execute(Application application, PreviewRequest parameters) {
        if (application == null) {
            LOGGER.error("DataWeave :: Application cannot be null");
            throw new IllegalArgumentException("Application cannot be null");
        }
        return this.doExecute((DeployableArtifact)application, parameters);
    }

    public PreviewResponse execute(Domain domain, PreviewRequest parameters) {
        if (domain == null) {
            LOGGER.error("DataWeave :: Domain cannot be null");
            throw new IllegalArgumentException("Domain cannot be null");
        }
        return this.doExecute((DeployableArtifact)domain, parameters);
    }

    private PreviewResponse doExecute(DeployableArtifact artifact, PreviewRequest parameters) {
        return this.executeWithApplicationClassLoader(artifact, () -> this.dataWeaveExecutor.execute(parameters, (ExpressionManager)artifact.getRegistry().lookupByName("_muleExpressionManager").get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T executeWithApplicationClassLoader(DeployableArtifact artifact, Supplier<T> supplier) {
        ClassLoader currentClassLoader = Thread.currentThread().getContextClassLoader();
        ClassLoader artifactClassLoader = artifact.getArtifactClassLoader().getClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(artifactClassLoader);
            T t = supplier.get();
            return t;
        }
        finally {
            Thread.currentThread().setContextClassLoader(currentClassLoader);
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return ImmutableList.of();
    }

    protected void doStart() throws MuleException {
    }

    protected void doStop() throws MuleException {
    }
}

