/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tryit;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.agent.configuration.Type;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import com.mulesoft.agent.domain.tracking.ReplayLevel;
import com.mulesoft.agent.domain.tracking.TrackingLevel;
import com.mulesoft.agent.domain.tryit.MessageHistoryCollectorInternalHandlerNotEnabledException;
import com.mulesoft.agent.exception.NoSuchApplicationException;
import com.mulesoft.agent.handlers.InternalMessageHandler;
import com.mulesoft.agent.services.ConfigurableAgentService;
import com.mulesoft.agent.services.MessageHistory;
import com.mulesoft.agent.services.TrackingService;
import com.mulesoft.agent.services.injector.SchedulerServiceAware;
import com.mulesoft.agent.services.tryit.MessageHistoryApplication;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.inject.Named;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.api.scheduler.SchedulerConfig;
import org.mule.runtime.api.scheduler.SchedulerService;

@Named(value="mule.agent.messageHistory.service")
@Singleton
public class MuleAgentMessageHistory
extends ConfigurableAgentService
implements MessageHistory,
SchedulerServiceAware {
    private static final Logger LOGGER = LogManager.getLogger(MuleAgentMessageHistory.class);
    private final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private final Lock readLock = this.readWriteLock.readLock();
    private final Lock writeLock = this.readWriteLock.writeLock();
    private Map<String, MessageHistoryApplication> tryItApplications = new HashMap<String, MessageHistoryApplication>();
    @Inject
    private TrackingService trackingService;
    private InternalMessageHandler<AgentTrackingNotification> agentTrackingNotificationInternalMessageHandler;
    private SchedulerService schedulerService;
    private Scheduler scheduler;
    @Configurable(value="-1")
    @Deprecated
    private int expireAfterAccessApplicationsThreadNumber = -1;
    @Configurable(value="100", type=Type.DYNAMIC)
    private int queueSize = 100;
    @Configurable(value="60", type=Type.DYNAMIC)
    private int expireAfterAccessApplicationsThreshold = 60;
    @Configurable(value="90", type=Type.DYNAMIC)
    private int expireAfterAccessApplicationFrequency = 90;

    public void enableMessageHistory(String applicationName) throws MessageHistoryCollectorInternalHandlerNotEnabledException {
        this.checkTryItInternalIsEnabled();
        this.writeLock.lock();
        try {
            this.trackingService.track(applicationName, TrackingLevel.DEBUG, ReplayLevel.NONE, false, false, true);
            this.tryItApplications.putIfAbsent(applicationName, new MessageHistoryApplication(this.queueSize));
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void checkTryItInternalIsEnabled() {
        if (this.agentTrackingNotificationInternalMessageHandler == null) {
            throw new MessageHistoryCollectorInternalHandlerNotEnabledException("mule.agent.tracking.handler.messageHistory is not present");
        }
        if (!this.agentTrackingNotificationInternalMessageHandler.isEnabled()) {
            throw new MessageHistoryCollectorInternalHandlerNotEnabledException("mule.agent.tracking.handler.messageHistory should be enabled in order to use this service");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<AgentTrackingNotification> retrieveNotifications(String applicationName, int chunkSize) {
        this.readLock.lock();
        try {
            MessageHistoryApplication messageHistoryApplication = this.tryItApplications.get(applicationName);
            if (messageHistoryApplication == null) {
                throw new NoSuchApplicationException("No application found for applicationName: " + applicationName);
            }
            List<AgentTrackingNotification> list = messageHistoryApplication.pollNotifications(chunkSize);
            return list;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void disableMessageHistory(String applicationName) {
        this.writeLock.lock();
        try {
            this.trackingService.untrack(applicationName);
            this.tryItApplications.remove(applicationName);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bufferAgentTrackingNotifications(String applicationName, List<AgentTrackingNotification> agentTrackingNotifications) {
        this.readLock.lock();
        try {
            if (this.tryItApplications.containsKey(applicationName)) {
                MessageHistoryApplication messageHistoryApplication = this.tryItApplications.get(applicationName);
                messageHistoryApplication.addNotifications(agentTrackingNotifications);
            }
        }
        finally {
            this.readLock.unlock();
        }
    }

    public List<InternalMessageHandler> getInternalHandlers() {
        return new ArrayList<InternalMessageHandler>();
    }

    protected void doStart() throws MuleException {
        if (this.expireAfterAccessApplicationsThreadNumber != -1) {
            LOGGER.info("Ignored property configuration expireAfterAccessApplicationsThreadNumber");
        }
        this.scheduler = this.schedulerService.customScheduler(SchedulerConfig.config().withName("MessageHistoryAutoDisable").withPrefix("MuleAgent").withShutdownTimeout(100L, TimeUnit.MILLISECONDS).withMaxConcurrentTasks(1));
        this.scheduler.scheduleWithFixedDelay(() -> {
            this.writeLock.lock();
            try {
                new ArrayList<String>(this.tryItApplications.keySet()).stream().forEach(applicationName -> {
                    try {
                        MessageHistoryApplication messageHistoryApplication = this.tryItApplications.get(applicationName);
                        if (System.currentTimeMillis() - messageHistoryApplication.getHeartBeatTime() > TimeUnit.SECONDS.toMillis(this.expireAfterAccessApplicationsThreshold)) {
                            this.disableMessageHistory((String)applicationName);
                            LOGGER.warn("Application: {} auto-disabled from try", applicationName);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.warn("Error while disabling for message history application: ", applicationName);
                    }
                });
            }
            finally {
                this.writeLock.unlock();
            }
        }, (long)this.expireAfterAccessApplicationFrequency, (long)this.expireAfterAccessApplicationFrequency, TimeUnit.SECONDS);
    }

    protected void doStop() throws MuleException {
        ArrayList<String> applicationNames;
        this.readLock.lock();
        try {
            applicationNames = new ArrayList<String>(this.tryItApplications.keySet());
            if (this.scheduler != null) {
                this.scheduler.stop();
            }
        }
        finally {
            this.readLock.unlock();
        }
        if (applicationNames != null) {
            applicationNames.stream().forEach(applicationName -> this.disableMessageHistory((String)applicationName));
        }
    }

    @Inject
    public void setAgentTrackingNotificationInternalMessageHandler(@Named(value="mule.agent.tracking.handler.messageHistory") InternalMessageHandler<AgentTrackingNotification> agentTrackingNotificationInternalMessageHandler) {
        this.agentTrackingNotificationInternalMessageHandler = agentTrackingNotificationInternalMessageHandler;
    }

    public void setSchedulerService(SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
    }
}

