/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.services.tryit;

import com.google.common.collect.EvictingQueue;
import com.google.common.collect.Queues;
import com.mulesoft.agent.domain.tracking.AgentTrackingNotification;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.stream.IntStream;
import org.mule.runtime.api.notification.MessageProcessorNotification;
import org.mule.runtime.core.api.util.ClassUtils;

public class MessageHistoryApplication {
    private long heartBeatTime = System.currentTimeMillis();
    private Queue<AgentTrackingNotification> queue;

    public MessageHistoryApplication(int queueSize) {
        EvictingQueue queue = EvictingQueue.create((int)queueSize);
        this.queue = Queues.synchronizedQueue((Queue)queue);
    }

    public List<AgentTrackingNotification> pollNotifications(int chunkSize) {
        this.heartBeatTime = System.currentTimeMillis();
        ArrayList<AgentTrackingNotification> notifications = new ArrayList<AgentTrackingNotification>();
        IntStream.range(0, chunkSize).forEach(nbr -> {
            AgentTrackingNotification notification = this.queue.poll();
            if (notification != null) {
                notifications.add(notification);
            }
        });
        return notifications;
    }

    public long getHeartBeatTime() {
        return this.heartBeatTime;
    }

    public void addNotifications(List<AgentTrackingNotification> notifications) {
        notifications.forEach(notification -> {
            if (notification.getNotificationType().equals(ClassUtils.getClassName(MessageProcessorNotification.class))) {
                this.queue.add((AgentTrackingNotification)notification);
            }
        });
    }
}

