/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apidesigner.resource.projects.projectId.branches;

import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.GenericType;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.apidesigner.exceptions.ApiDesignerXapiException;
import org.mule.apidesigner.resource.projects.projectId.branches.model.Branch;
import org.mule.apidesigner.resource.projects.projectId.branches.model.BranchesGETHeader;
import org.mule.apidesigner.resource.projects.projectId.branches.model.BranchesPOSTHeader;
import org.mule.apidesigner.responses.ApiDesignerXapiResponse;

public class Branches {
    private String _baseUrl;
    private Client _client;

    public Branches() {
        this._baseUrl = null;
        this._client = null;
    }

    public Branches(String baseUrl, Client _client) {
        this._baseUrl = baseUrl + "/branches";
        this._client = _client;
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ApiDesignerXapiResponse<Void> post(org.mule.apidesigner.model.Branch body, BranchesPOSTHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXOrganizationId() != null) {
            invocationBuilder.header("x-organization-id", (Object)headers.getXOrganizationId());
        }
        if (headers.getXOwnerId() != null) {
            invocationBuilder.header("x-owner-id", (Object)headers.getXOwnerId());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("POST", Entity.json((Object)body));
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ApiDesignerXapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ApiDesignerXapiResponse<Object> apiResponse = new ApiDesignerXapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ApiDesignerXapiResponse<List<Branch>> get(BranchesGETHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXOrganizationId() != null) {
            invocationBuilder.header("x-organization-id", (Object)headers.getXOrganizationId());
        }
        if (headers.getXOwnerId() != null) {
            invocationBuilder.header("x-owner-id", (Object)headers.getXOwnerId());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ApiDesignerXapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ApiDesignerXapiResponse<Object> apiResponse = new ApiDesignerXapiResponse<Object>(response.readEntity((GenericType)new GenericType<List<Branch>>(){}), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public org.mule.apidesigner.resource.projects.projectId.branches.branch.Branch branch(String branch) {
        return new org.mule.apidesigner.resource.projects.projectId.branches.branch.Branch(this.getBaseUri(), this.getClient(), branch);
    }
}

