/*
 * Decompiled with CFR 0.152.
 */
package org.mule.apidesigner.resource.projects.projectId;

import java.net.URLEncoder;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.mule.apidesigner.exceptions.ApiDesignerXapiException;
import org.mule.apidesigner.model.Project;
import org.mule.apidesigner.resource.projects.projectId.api.Api;
import org.mule.apidesigner.resource.projects.projectId.branches.Branches;
import org.mule.apidesigner.resource.projects.projectId.model.ProjectIdDELETEHeader;
import org.mule.apidesigner.resource.projects.projectId.model.ProjectIdGETHeader;
import org.mule.apidesigner.responses.ApiDesignerXapiResponse;

public class ProjectId {
    private String _baseUrl;
    private Client _client;
    public final Branches branches;
    public final Api api;

    public ProjectId() {
        this._baseUrl = null;
        this._client = null;
        this.branches = null;
        this.api = null;
    }

    public ProjectId(String baseUrl, Client _client, String uriParam) {
        this._baseUrl = baseUrl + "/" + URLEncoder.encode(uriParam);
        this._client = _client;
        this.branches = new Branches(this.getBaseUri(), this.getClient());
        this.api = new Api(this.getBaseUri(), this.getClient());
    }

    protected Client getClient() {
        return this._client;
    }

    private String getBaseUri() {
        return this._baseUrl;
    }

    public ApiDesignerXapiResponse<Project> get(ProjectIdGETHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXOrganizationId() != null) {
            invocationBuilder.header("x-organization-id", (Object)headers.getXOrganizationId());
        }
        if (headers.getXOwnerId() != null) {
            invocationBuilder.header("x-owner-id", (Object)headers.getXOwnerId());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("GET");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ApiDesignerXapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ApiDesignerXapiResponse<Object> apiResponse = new ApiDesignerXapiResponse<Object>(response.readEntity(Project.class), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }

    public ApiDesignerXapiResponse<Void> delete(ProjectIdDELETEHeader headers, String authorizationToken) {
        WebTarget target = this._client.target(this.getBaseUri());
        Invocation.Builder invocationBuilder = target.request(new MediaType[]{MediaType.APPLICATION_JSON_TYPE});
        if (headers.getXOrganizationId() != null) {
            invocationBuilder.header("x-organization-id", (Object)headers.getXOrganizationId());
        }
        if (headers.getXOwnerId() != null) {
            invocationBuilder.header("x-owner-id", (Object)headers.getXOwnerId());
        }
        invocationBuilder.header("Authorization", (Object)("bearer " + authorizationToken));
        Response response = invocationBuilder.method("DELETE");
        if (response.getStatusInfo().getFamily() != Response.Status.Family.SUCCESSFUL) {
            Response.StatusType statusInfo = response.getStatusInfo();
            throw new ApiDesignerXapiException(statusInfo.getStatusCode(), statusInfo.getReasonPhrase(), (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        }
        ApiDesignerXapiResponse<Object> apiResponse = new ApiDesignerXapiResponse<Object>(null, (MultivaluedMap<String, String>)response.getStringHeaders(), response);
        return apiResponse;
    }
}

