/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.validators;

import com.mulesoft.agent.validators.TruststoreConfig;
import java.util.Map;

public class ValidatorArgs {
    public static final String APPLICATION_NAME_KEY = "_APPLICATION_NAME";
    public static final String APPLICATION_FILE_PATH_KEY = "_APPLICATION_FILE_PATH";
    public static final String TRUSTSTORE_PATH_KEY = "truststore";
    public static final String TRUSTSTORE_ALIAS_KEY = "truststoreAlias";
    public static final String TRUSTSTORE_TYPE_KEY = "truststoreType";
    public static final String TRUSTSTORE_PASSWORD_KEY = "truststorePassword";
    private final Map<String, Object> args;

    private ValidatorArgs(Map<String, Object> args) {
        this.args = args;
    }

    public static ValidatorArgs valueOf(Map<String, Object> args) {
        return new ValidatorArgs(args);
    }

    public TruststoreConfig getTruststoreConfig() {
        String type = (String)this.args.get(TRUSTSTORE_TYPE_KEY);
        String path = (String)this.args.get(TRUSTSTORE_PATH_KEY);
        String password = (String)this.args.get(TRUSTSTORE_PASSWORD_KEY);
        String alias = (String)this.args.get(TRUSTSTORE_ALIAS_KEY);
        return TruststoreConfig.newInstance(this.getTruststoreType(type), alias, path, password);
    }

    public String getArtifactPath() {
        return (String)this.args.get(APPLICATION_FILE_PATH_KEY);
    }

    private String getTruststoreType(String type) {
        if (type == null) {
            return "JKS";
        }
        return type;
    }
}

