/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.validators;

import com.mulesoft.agent.exception.ApplicationValidationException;
import com.mulesoft.agent.services.ApplicationValidator;
import com.mulesoft.agent.services.EncryptionService;
import com.mulesoft.agent.validators.FileUtils;
import com.mulesoft.agent.validators.JarSigner;
import com.mulesoft.agent.validators.KeystoreUtils;
import com.mulesoft.agent.validators.TruststoreConfig;
import com.mulesoft.agent.validators.ValidatorArgs;
import com.mulesoft.agent.validators.exceptions.KeyStoreException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Map;
import java.util.Optional;
import java.util.jar.JarFile;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.signature.validator")
@Singleton
public class MuleAgentSignatureValidator
implements ApplicationValidator {
    private static final Logger LOGGER = LogManager.getLogger(MuleAgentSignatureValidator.class);
    @Inject
    EncryptionService encryptionService;

    public String getType() {
        return "jarSignatureValidator";
    }

    public String getName() {
        return "defaultJarSignatureValidator";
    }

    public void validate(Map<String, Object> args) throws IOException, ApplicationValidationException {
        ValidatorArgs validatorArgs = ValidatorArgs.valueOf(args);
        TruststoreConfig truststoreConfig = validatorArgs.getTruststoreConfig();
        String artifactPath = validatorArgs.getArtifactPath();
        Optional<Path> truststorePath = FileUtils.getTrustStorePath(truststoreConfig.getPath());
        String truststorePassword = null;
        try {
            truststorePassword = this.encryptionService.decrypt(truststoreConfig.getPassword());
        }
        catch (Exception e) {
            LOGGER.error((Object)e);
        }
        KeyStore jarSigners = FileUtils.loadTruststore(truststorePath, truststoreConfig.getType(), truststorePassword);
        JarFile jarFile = this.newJarFile(artifactPath);
        if (StringUtils.isBlank((String)truststoreConfig.getAlias())) {
            JarSigner.newInstance(jarFile, jarSigners).verify();
            return;
        }
        Optional<Certificate> certificate = KeystoreUtils.getCertificate(jarSigners, truststoreConfig.getAlias());
        if (!certificate.isPresent()) {
            throw new KeyStoreException(String.format("Alias '%s' not found in keystore", truststoreConfig.getAlias()));
        }
        try {
            X509Certificate x509 = (X509Certificate)certificate.get();
            x509.checkValidity(new Date());
        }
        catch (CertificateExpiredException | CertificateNotYetValidException e) {
            LOGGER.error("There was an error validating the certificate with the alias '{}' - {} Reason: '{}'", (Object)truststoreConfig.getAlias(), (Object)e.getClass().getSimpleName(), (Object)e.getMessage());
            throw new ApplicationValidationException(String.format("%s - %s", e.getClass().getSimpleName(), e.getMessage()));
        }
        JarSigner.newInstance(jarFile, jarSigners, truststoreConfig.getAlias()).verify();
    }

    private JarFile newJarFile(String path) throws IOException {
        File file = new File(path);
        return new JarFile(file, true);
    }
}

