/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.validators;

import com.mulesoft.agent.validators.exceptions.KeyStoreException;
import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class KeystoreUtils {
    private static final Logger LOGGER = LogManager.getLogger(KeystoreUtils.class);

    private KeystoreUtils() {
    }

    private static File newFileOrElseThrowsException(String path) throws KeyStoreException {
        File file = new File(path);
        if (!file.exists()) {
            String message = String.format("Unable to load the Jar Signers truststore '%s'. Reason: File does not exists.", path);
            LOGGER.error(message);
            throw new KeyStoreException(message);
        }
        return file;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static KeyStore newKeystoreOrElseThrowException(File file, String type, char[] password) throws KeyStoreException {
        try (FileInputStream fis = new FileInputStream(file);){
            KeyStore keystore = KeyStore.getInstance(type);
            keystore.load(fis, password);
            KeyStore keyStore = keystore;
            return keyStore;
        }
        catch (Exception e) {
            String message = String.format("Unable to load Jar Signers truststore '%s'. Reason: %s", file.getAbsolutePath(), e.getMessage());
            LOGGER.error(message);
            throw new KeyStoreException(message);
        }
    }

    public static KeyStore load(String path, String keystoreType, char[] keystorePassword) throws KeyStoreException {
        File file = KeystoreUtils.newFileOrElseThrowsException(path);
        KeyStore keystore = KeystoreUtils.newKeystoreOrElseThrowException(file, keystoreType, keystorePassword);
        LOGGER.info("Loading Jar Signers Truststore from '{}'", (Object)path);
        return keystore;
    }

    public static Optional<Certificate> getCertificate(KeyStore keystore, String alias) {
        Certificate c = null;
        try {
            c = keystore.getCertificate(alias);
        }
        catch (Exception e) {
            LOGGER.error("Unable to retrieve certificate using the alias '{}' from keystore. Reason: {}", (Object)alias, (Object)e.getMessage(), (Object)e);
            return Optional.empty();
        }
        return Optional.ofNullable(c);
    }
}

