/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.validators;

import com.mulesoft.agent.validators.exceptions.SignatureVerificationFailedException;
import java.io.IOException;
import java.io.InputStream;
import java.security.CodeSigner;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JarSigner {
    private static final Logger LOGGER = LogManager.getLogger(JarSigner.class);
    private final JarFile jarFile;
    private final KeyStore truststore;
    private final String alias;

    private JarSigner(JarFile jarFile, KeyStore truststore, String alias) {
        this.jarFile = jarFile;
        this.truststore = truststore;
        this.alias = alias;
    }

    public static JarSigner newInstance(JarFile jarFile, KeyStore truststore) {
        return new JarSigner(jarFile, truststore, null);
    }

    public static JarSigner newInstance(JarFile jarFile, KeyStore truststore, String alias) {
        return new JarSigner(jarFile, truststore, alias);
    }

    private static boolean isSignatureBlockFile(String name) {
        if (name == null) {
            return false;
        }
        String upperName = name.toUpperCase();
        return upperName.endsWith(".SF") || upperName.endsWith(".DSA") || upperName.endsWith(".RSA") || upperName.endsWith(".EC");
    }

    public void verify() throws IOException, SignatureVerificationFailedException {
        Vector<JarEntry> jarEntries = this.readJarEntries(this.jarFile);
        Manifest manifest = this.jarFile.getManifest();
        this.validate(this.truststore, this.alias, manifest, jarEntries);
        if (StringUtils.isBlank((String)this.alias)) {
            LOGGER.info("Jar Signature verified: File {}", (Object)this.jarFile.getName());
        } else {
            LOGGER.info("Jar Signature verified using certificate alias '{}': File '{}'", (Object)this.alias, (Object)this.jarFile.getName());
        }
    }

    private void validate(KeyStore truststore, String alias, Manifest manifest, Vector<JarEntry> jarEntries) throws SignatureVerificationFailedException {
        int filesCount = 0;
        int signedFilesCount = 0;
        if (manifest == null) {
            String message = "Artifact is unsigned. (signatures missing or not parsable)";
            LOGGER.error(message);
            throw new SignatureVerificationFailedException(message);
        }
        for (JarEntry jarEntry : jarEntries) {
            boolean isSigned;
            if (jarEntry.isDirectory() || JarSigner.isSignatureBlockFile(jarEntry.getName())) continue;
            ++filesCount;
            CodeSigner[] codeSigners = jarEntry.getCodeSigners();
            boolean bl = isSigned = codeSigners != null;
            if (!isSigned) continue;
            for (CodeSigner signer : codeSigners) {
                if (!this.contains(truststore, alias, signer)) continue;
                ++signedFilesCount;
            }
        }
        if (filesCount != signedFilesCount) {
            String message = "Signature validation failed.";
            LOGGER.error(message);
            throw new SignatureVerificationFailedException(message);
        }
    }

    private Vector<JarEntry> readJarEntries(JarFile jarFile) {
        Vector<JarEntry> jarEntries = new Vector<JarEntry>();
        byte[] buffer = new byte[8192];
        Collections.list(jarFile.entries()).forEach(entry -> {
            jarEntries.add((JarEntry)entry);
            try (InputStream is = null;){
                int n;
                is = jarFile.getInputStream((ZipEntry)entry);
                while ((n = is.read(buffer, 0, buffer.length)) != -1) {
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        return jarEntries;
    }

    private boolean contains(KeyStore keystore, String alias, CodeSigner codeSigner) {
        if (alias == null) {
            return this.contains(keystore, codeSigner);
        }
        Optional<Certificate> certificate = this.getCertificate(keystore, alias);
        if (!certificate.isPresent()) {
            LOGGER.error("Certificate with alias '{}' not found in truststore", (Object)this.jarFile.getName());
            return false;
        }
        return this.contains(certificate.get(), codeSigner);
    }

    private boolean contains(KeyStore keystore, CodeSigner codeSigner) {
        List<? extends Certificate> certificates = codeSigner.getSignerCertPath().getCertificates();
        try {
            for (Certificate certificate : certificates) {
                String alias = keystore.getCertificateAlias(certificate);
                if (alias == null) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private Optional<Certificate> getCertificate(KeyStore keystore, String alias) {
        try {
            Certificate certificate = keystore.getCertificate(alias);
            return Optional.of(certificate);
        }
        catch (Exception e) {
            LOGGER.error("Unable to retrieve the certificate with alias '{}'. Reason: '{}'", (Object)alias, (Object)e.getMessage());
            return Optional.empty();
        }
    }

    private boolean contains(Certificate certificate, CodeSigner codeSigner) {
        List<? extends Certificate> certificates = codeSigner.getSignerCertPath().getCertificates();
        boolean verified = false;
        for (Certificate certificate2 : certificates) {
            if (!this.verify(certificate2, certificate)) continue;
            verified = true;
            break;
        }
        return verified;
    }

    private boolean verify(Certificate c1, Certificate c2) {
        try {
            c1.verify(c2.getPublicKey());
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

