/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.validators;

import com.mulesoft.agent.validators.KeystoreUtils;
import com.mulesoft.agent.validators.exceptions.KeyStoreException;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyStore;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FileUtils {
    private static final Logger LOGGER = LogManager.getLogger(FileUtils.class);

    private FileUtils() {
    }

    public static String jvmCacertsPath() {
        String sep = File.separator;
        return System.getProperty("java.home") + sep + "lib" + sep + "security" + sep + "cacerts";
    }

    public static KeyStore loadTruststore(Optional<Path> truststoreFile, String keystoreType, String keystorePassword) throws KeyStoreException {
        String truststorePath = FileUtils.getAbsolutePathOrElseCacertsPath(truststoreFile);
        char[] password = keystorePassword == null ? null : keystorePassword.toCharArray();
        try {
            return KeystoreUtils.load(truststorePath, keystoreType, password);
        }
        catch (Exception e) {
            String message = String.format("Unable to load Jar Signers truststore '%s'. Reason: %s", truststorePath, e.getMessage());
            LOGGER.error(message);
            throw new KeyStoreException(message);
        }
    }

    private static String getAbsolutePathOrElseCacertsPath(Optional<Path> path) {
        return path.isPresent() ? path.get().toAbsolutePath().toString() : FileUtils.jvmCacertsPath();
    }

    public static Optional<Path> getTrustStorePath(String filePath) {
        if (filePath == null) {
            LOGGER.warn("Truststore property not defined for Artifact Validator Service");
            return Optional.empty();
        }
        if (filePath.isEmpty()) {
            LOGGER.warn("Truststore property in Artifact Validator Service configuration is empty");
            return Optional.empty();
        }
        Path path = Paths.get(filePath, new String[0]);
        if (path.isAbsolute() && Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            return Optional.of(path);
        }
        if (path.getParent() != null) {
            LOGGER.error("Relative path in truststore file reference not supported by Artifact Validator Service.");
            return Optional.empty();
        }
        String configurationFolder = System.getProperty("mule.agent.configuration.folder");
        path = Paths.get(configurationFolder + File.separator + path.getFileName().toString(), new String[0]);
        if (Files.isRegularFile(path, LinkOption.NOFOLLOW_LINKS)) {
            return Optional.of(path);
        }
        return Optional.empty();
    }
}

