/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal.spi;

import com.equo.chromium.swt.internal.spi.DelegatingCefResourceHandler;
import com.equo.chromium.swt.internal.spi.SchemeHandler;
import com.equo.chromium.swt.internal.spi.SchemeHandlerManager;
import java.net.URI;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.callback.CefCallback;
import org.cef.callback.CefSchemeHandlerFactory;
import org.cef.handler.CefResourceHandler;
import org.cef.network.CefRequest;

public class DynamicCefSchemeHandlerFactory
implements CefSchemeHandlerFactory {
    private SchemeHandlerManager schemeHandlerManager;

    public DynamicCefSchemeHandlerFactory(SchemeHandlerManager schemeHandlerManager) {
        this.schemeHandlerManager = schemeHandlerManager;
    }

    @Override
    public CefResourceHandler create(CefBrowser browser, CefFrame frame, String schemeName, CefRequest request) {
        String TEXT_URL = System.getProperty("chromium.setTextAsUrl", "");
        if (!TEXT_URL.isEmpty() && request.getURL().startsWith(TEXT_URL) && (browser.isPopup() || !"setText".equals(request.getHeaderByName("chromium")))) {
            return null;
        }
        try {
            URI requestUri = URI.create(request.getURL());
            SchemeHandler schemeHandler = this.schemeHandlerManager.getSchemeHandler(schemeName, requestUri.getAuthority());
            if (schemeHandler != null) {
                DelegatingCefResourceHandler handler = new DelegatingCefResourceHandler(schemeHandler);
                handler.processRequest(request, frame);
                if (handler.processRequest(request, (CefCallback)null)) {
                    return handler;
                }
            }
        }
        finally {
            return null;
        }
    }
}

