/*
 * Decompiled with CFR 0.152.
 */
package com.equo.chromium.swt.internal.spi;

import com.equo.chromium.swt.internal.spi.CommMessageError;
import com.equo.chromium.swt.internal.spi.CommunicationManager;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import org.cef.browser.CefBrowser;
import org.cef.browser.CefFrame;
import org.cef.browser.CefMessageRouter;
import org.cef.callback.CefQueryCallback;
import org.cef.handler.CefMessageRouterHandlerAdapter;

public class CommRouterHandler
extends CefMessageRouterHandlerAdapter {
    private CommunicationManager commManager;
    private static ExecutorService threadPool = Executors.newCachedThreadPool(new DaemonThreadFactory());
    private static ExecutorService queueThread = Executors.newSingleThreadExecutor(new DaemonThreadFactory());

    public static CefMessageRouter createRouter() {
        CefMessageRouter.CefMessageRouterConfig config = new CefMessageRouter.CefMessageRouterConfig("equoSend", "equoSendCancel");
        return CefMessageRouter.create(config);
    }

    public CommRouterHandler(CommunicationManager commManager) {
        this.commManager = commManager;
    }

    private void handleRequest(String request, CefQueryCallback callback) {
        try {
            Optional<String> response = this.commManager.receiveMessage(request);
            if (response.isPresent()) {
                callback.success(response.get());
            }
        }
        catch (CommMessageError e) {
            callback.failure(e.getErrorCode(), e.getLocalizedMessage());
        }
    }

    @Override
    public boolean onQuery(CefBrowser browser, CefFrame frame, long queryId, String request, boolean persistent, CefQueryCallback callback) {
        if (request.startsWith("&-")) {
            queueThread.execute(() -> this.handleRequest(request.substring(2), callback));
        } else {
            threadPool.execute(() -> this.handleRequest(request, callback));
        }
        return true;
    }

    private static class DaemonThreadFactory
    implements ThreadFactory {
        private final AtomicInteger threadNumber = new AtomicInteger(1);
        private final ThreadGroup group;
        private final String namePrefix;

        DaemonThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
            this.namePrefix = "comm-pool-thread-";
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            t.setPriority(5);
            return t;
        }
    }
}

