/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.agent.gw.http.db;

import com.fasterxml.uuid.Generators;
import com.mulesoft.agent.common.internalhandler.AbstractDBInternalHandler;
import com.mulesoft.agent.configuration.Configurable;
import com.mulesoft.mule.runtime.gw.api.analytics.AnalyticsHttpEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Collection;
import java.util.UUID;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Named(value="mule.agent.gw.http.handler.database")
@Singleton
public class GatewayHttpEventsDBInternalHandler
extends AbstractDBInternalHandler<AnalyticsHttpEvent> {
    private static final Logger LOGGER = LogManager.getLogger(GatewayHttpEventsDBInternalHandler.class);
    @Configurable(value="MULE_API_ANALYTICS")
    String apiAnalyticsTable;

    protected void insert(Connection connection, Collection<AnalyticsHttpEvent> notifications) throws SQLException {
        String insertIntoApiAnalyticsTableQuery = String.format("INSERT INTO %s (id, api_id, api_name, api_version, api_version_id, application_name, client_id, client_ip, event_id, host_id, org_id, path, policy_violation_policy_id, policy_violation_policy_name, policy_violation_outcome, received_ts, replied_ts, request_bytes, request_disposition, response_bytes, status_code, transaction_id, user_agent, verb) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", this.apiAnalyticsTable);
        try (PreparedStatement eventInsert = connection.prepareStatement(insertIntoApiAnalyticsTableQuery);){
            for (AnalyticsHttpEvent notification : notifications) {
                LOGGER.debug("Inserting notification: " + notification);
                this.insertEvent(eventInsert, notification);
            }
            eventInsert.executeBatch();
        }
    }

    private UUID insertEvent(PreparedStatement statement, AnalyticsHttpEvent event) throws SQLException {
        UUID id = Generators.timeBasedGenerator().generate();
        int parameterIndex = 1;
        statement.setString(parameterIndex++, id.toString());
        statement.setInt(parameterIndex++, event.getApiId());
        statement.setString(parameterIndex++, event.getApiName());
        statement.setString(parameterIndex++, event.getApiVersion());
        statement.setLong(parameterIndex++, event.getApiVersionId());
        statement.setString(parameterIndex++, event.getApplicationName());
        statement.setString(parameterIndex++, event.getClientId());
        statement.setString(parameterIndex++, event.getClientIp());
        statement.setString(parameterIndex++, event.getEventId());
        statement.setString(parameterIndex++, event.getHostId());
        statement.setString(parameterIndex++, event.getOrgId());
        statement.setString(parameterIndex++, event.getPath());
        if (event.getPolicyViolation() == null) {
            statement.setNull(parameterIndex++, 4);
            statement.setNull(parameterIndex++, 12);
            statement.setNull(parameterIndex++, 12);
        } else {
            statement.setString(parameterIndex++, event.getPolicyViolation().getPolicyId());
            statement.setString(parameterIndex++, event.getPolicyViolation().getPolicyName());
            statement.setString(parameterIndex++, event.getPolicyViolation().getOutcome().getName());
        }
        statement.setString(parameterIndex++, event.getReceivedTs());
        statement.setString(parameterIndex++, event.getRepliedTs());
        statement.setInt(parameterIndex++, event.getRequestBytes());
        statement.setString(parameterIndex++, event.getRequestDisposition().getName());
        statement.setInt(parameterIndex++, event.getResponseBytes());
        statement.setInt(parameterIndex++, event.getStatusCode());
        statement.setString(parameterIndex++, event.getTransactionId());
        statement.setString(parameterIndex++, event.getUserAgent());
        statement.setString(parameterIndex, event.getVerb());
        statement.addBatch();
        return id;
    }
}

