/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.internal.meta;

import java.util.Collections;
import java.util.List;
import org.eclipse.swt.widgets.Widget;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.core.event.CoreEventTypes;
import org.mule.tooling.core.event.MetadataKeyFieldEditorEditedEvent;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.messageflow.util.MessageFlowUtils;
import org.mule.tooling.metadata.cache.MetadataTypesManager;
import org.mule.tooling.model.messageflow.ComponentId;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.model.messageflow.path.MulePath;
import org.mule.tooling.ui.modules.core.widgets.AttributesPropertyPage;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedListener;
import org.mule.tooling.ui.modules.core.widgets.IEditorValueModifiedObservable;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.EditorHelper;
import org.mule.tooling.ui.modules.core.widgets.editors.EnumFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.MultiLevelTypeChooserDataSenseJobListener;
import org.mule.tooling.ui.modules.core.widgets.editors.TypeChooserDataSenseJobListener;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelperComponent;
import org.mule.tooling.ui.modules.internal.meta.RefreshTypesJobHelper;
import org.mule.tooling.utils.eventbus.EventBus;
import org.mule.tooling.utils.eventbus.EventBusHelper;
import org.mule.tooling.utils.eventbus.IEvent;
import org.mule.tooling.utils.eventbus.IEventHandler;

public class TypeChooserComponent
implements AttributeHelperComponent {
    private final List<String> keyParts;

    public TypeChooserComponent(List<String> keyParts) {
        this.keyParts = keyParts == null ? Collections.emptyList() : keyParts;
    }

    @Override
    public void bind(IFieldEditor editor) {
        if (editor instanceof IEditorValueModifiedObservable) {
            boolean evictOnModify = !(editor instanceof EnumFieldEditor);
            ((IEditorValueModifiedObservable)((Object)editor)).addModificationListener(new ValueModifiedListener(editor, evictOnModify));
        }
        if (editor instanceof EnumFieldEditor) {
            EnumFieldEditor enumEditor = (EnumFieldEditor)editor;
            EventBus eventBus = MuleCorePlugin.getEventBus();
            EventBusHelper eventBusHelper = new EventBusHelper();
            if (this.getPartName().isEmpty()) {
                eventBusHelper.registerUIListener(eventBus, CoreEventTypes.ON_DATASENSE_JOB_EVENT, (IEventHandler)new TypeChooserDataSenseJobListener(enumEditor));
            } else {
                eventBusHelper.registerUIListener(eventBus, CoreEventTypes.ON_DATASENSE_JOB_EVENT, (IEventHandler)new MultiLevelTypeChooserDataSenseJobListener(enumEditor, this.keyParts));
            }
            eventBusHelper.unregisterWith((Widget)editor.getControl());
        }
    }

    public List<String> getPartName() {
        return this.keyParts;
    }

    private static final class ValueModifiedListener
    implements IEditorValueModifiedListener {
        private final IFieldEditor editor;
        private final boolean evictOnModify;

        public ValueModifiedListener(IFieldEditor editor, boolean evictOnModify) {
            this.editor = editor;
            this.evictOnModify = evictOnModify;
        }

        @Override
        public void valueModified(String newValue) {
            this.updateEntityAndNotifyChange();
        }

        private void updateEntityAndNotifyChange() {
            AttributesPropertyPage parentPage = this.editor.getParentPage();
            IMessageFlowNode messageFlowNode = parentPage.getMessageFlowNode();
            IMuleProject muleProject = parentPage.getMuleProject();
            if (this.evictOnModify) {
                String path = ComponentId.from((IMessageFlowEntity)messageFlowNode).toString();
                ((MetadataTypesManager)muleProject.getProjectComponent(MetadataTypesManager.class)).getTypesManager().removeMetadataTypes(path);
                MuleConfiguration muleConfiguration = MessageFlowUtils.getFlowEditorFromActivePage().getMuleConfiguration();
                MulePath pathFor = muleConfiguration.getPathFor((IMessageFlowEntity)messageFlowNode);
                if (pathFor != null) {
                    path = pathFor.toPath();
                }
                RefreshTypesJobHelper.dispatchKeyEviction(parentPage, messageFlowNode, muleConfiguration, muleProject, path);
            }
            IMessageFlowNode updatedCurrentNode = MessageFlowUtils.getMessageFlowNodeWithUpdatedProperties((IMessageFlowNode)messageFlowNode, EditorHelper.getAllCurrentEditorPages(this.editor));
            MuleCorePlugin.getEventBus().fireEvent((IEvent)new MetadataKeyFieldEditorEditedEvent(muleProject, messageFlowNode, messageFlowNode.getProperties(), updatedCurrentNode.getProperties().toPropertyCollectionMap().asPropertyCollection()));
        }
    }
}

