/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import java.util.List;
import java.util.stream.Collectors;
import org.mule.tooling.core.validation.Message;
import org.mule.tooling.core.validation.Severity;
import org.mule.tooling.ui.widgets.IMessageLogger;

public class ValidationMessageUtils {
    public static List<IMessageLogger.ValidationMessage> asValidationMessages(List<Message> messages) {
        return messages.stream().map(ValidationMessageUtils::asValidationMessage).collect(Collectors.toList());
    }

    public static IMessageLogger.ValidationMessage asValidationMessage(Message message) {
        return new IMessageLogger.ValidationMessage(message.getMessage(), ValidationMessageUtils.asValidationMessageSeverity(message.getSeverity()), message.getFieldLabel());
    }

    private static IMessageLogger.ValidationMessageSeverity asValidationMessageSeverity(Severity severity) {
        switch (severity) {
            case ERROR: {
                return IMessageLogger.ValidationMessageSeverity.ERROR;
            }
            case WARNING: {
                return IMessageLogger.ValidationMessageSeverity.WARNING;
            }
        }
        return IMessageLogger.ValidationMessageSeverity.INFO;
    }
}

