/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import com.google.common.base.Predicate;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.FilteredResourcesSelectionDialog;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValueFactory;

public class ResourceFactory
implements IValueFactory {
    private static final String WSDL_FILE_EXTENSION = "*.wsdl";
    private String caption;
    private String containerLevelValue;
    private String resourceTypeValue;
    private String initialPatternValue;
    private Predicate<IResource> resourceFilter;

    public ResourceFactory(String caption, String containerLevelValue, String resourceTypeValue, String initialPatternValue) {
        this.caption = caption;
        this.containerLevelValue = containerLevelValue;
        this.resourceTypeValue = resourceTypeValue;
        this.initialPatternValue = initialPatternValue;
    }

    @Override
    public Object getValue(AttributeContext context) {
        Object container = null;
        container = this.containerLevelValue != null && this.containerLevelValue.equals("workspace") ? ResourcesPlugin.getWorkspace().getRoot() : (this.initialPatternValue != null && this.initialPatternValue.equals(WSDL_FILE_EXTENSION) ? context.getProject().getMuleResourcesFolder() : context.getProject().getProject());
        return this.getValue((IContainer)container);
    }

    public Object getValue(final IContainer container) {
        Object[] results;
        final int resourceTypesMask = this.retrieveResourceTypes();
        FilteredResourcesSelectionDialog dialog = new FilteredResourcesSelectionDialog(Display.getCurrent().getActiveShell(), false, container, resourceTypesMask){

            protected FilteredItemsSelectionDialog.ItemsFilter createFilter() {
                return new FilteredResourcesSelectionDialog.ResourceFilter(this, container, false, resourceTypesMask){

                    public boolean matchItem(Object item) {
                        if (super.matchItem(item)) {
                            return (this).ResourceFactory.this.resourceFilter == null ? true : (this).ResourceFactory.this.resourceFilter.apply((Object)((IResource)item));
                        }
                        return false;
                    }
                };
            }
        };
        if (this.initialPatternValue != null && !this.initialPatternValue.isEmpty()) {
            dialog.setInitialPattern(this.initialPatternValue);
        }
        dialog.setTitle(this.caption + " Browser");
        if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
            return results[0];
        }
        return null;
    }

    private int retrieveResourceTypes() {
        String[] values;
        if (this.resourceTypeValue == null || this.resourceTypeValue.isEmpty()) {
            return 7;
        }
        int resourceTypesMask = -1;
        String[] stringArray = values = this.resourceTypeValue.split(",");
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            resourceTypesMask = resourceTypesMask == -1 ? this.getFirstResourceTypes(value) : this.getLastResourceTypes(resourceTypesMask, value);
            ++n2;
        }
        if (resourceTypesMask == -1) {
            resourceTypesMask = 7;
        }
        return resourceTypesMask;
    }

    private int getLastResourceTypes(int resourceTypesMask, String value) {
        resourceTypesMask = value.equals("file") ? (resourceTypesMask |= 1) : (value.equals("folder") ? (resourceTypesMask |= 2) : (value.equals("project") ? (resourceTypesMask |= 4) : 7));
        return resourceTypesMask;
    }

    private int getFirstResourceTypes(String value) {
        int resourceTypesMask = value.equals("file") ? 1 : (value.equals("folder") ? 2 : (value.equals("project") ? 4 : 7));
        return resourceTypesMask;
    }

    @Override
    public String getName() {
        return "Resource";
    }

    public void setResourceFilter(Predicate<IResource> resourcePredicate) {
        this.resourceFilter = resourcePredicate;
    }
}

