/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.util.PropertiesUtils;
import org.mule.tooling.ui.modules.core.metadata.MetadataHelpers;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IEntityAwareValidator;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.editors.StringFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.NameEditorsStackContainer;
import org.mule.tooling.ui.modules.core.widgets.meta.creators.AttributeReader;

public class NameValidator
implements IValidator,
IEntityAwareValidator {
    public static final String NAME_REGEX = "[^,;&\\s]*";
    public static final String ID_SHOULD_BE_UNIQUE = "Id should be unique";
    public static final String NAME_MUST_BE_UNIQUE = "Name must be unique";
    public static final String NAME_MUST_BE_IDENT = "Name must be an identifier (does not support spaces, commas, semi-colons, etc.)";
    public static final String NAME_MUST_NOT_BE_EMPTY = "Name must not be empty";

    @Override
    public String validate(Object value, AttributeContext context, AttributeHelper helper) {
        return this.validate(value, context, null, null);
    }

    @Override
    public String validate(Object value, AttributeContext context, IMessageFlowNode node, IFieldEditor editor) {
        boolean springBeanId;
        String error;
        String val = value.toString();
        if (val.length() > 0 && !val.matches(NAME_REGEX)) {
            return NAME_MUST_BE_IDENT;
        }
        if (editor != null && editor.getHelper() != null) {
            if (val.length() == 0) {
                if (editor.getHelper().isRequired()) {
                    return NAME_MUST_NOT_BE_EMPTY;
                }
                return null;
            }
            for (NameEditorsStackContainer nesc : AttributeReader.currentNameEditorsList) {
                String editorId;
                StringFieldEditor nescEditor = (StringFieldEditor)nesc.editor;
                if (editor == nescEditor || !val.equals(nescEditor.getPublicValue())) continue;
                String string = editorId = StringUtils.isBlank((String)editor.getHelper().getSaveAs()) ? editor.getHelper().getId() : editor.getHelper().getSaveAs();
                if (!editorId.equals(nesc.id) || !StringUtils.isNotEmpty((String)editorId)) continue;
                return NAME_MUST_BE_UNIQUE;
            }
        }
        int count = 0;
        if (context == null) {
            return null;
        }
        ArrayList allGlobalEntries = new ArrayList(context.getGlobalEntries());
        ArrayList entityProcessed = Lists.newArrayList();
        if (editor == null || !editor.getHelper().getId().equals("id")) {
            for (IMessageFlowEntity flowNodeValue : allGlobalEntries) {
                MessageFlowNode toCompareNode;
                String name;
                if (!(flowNodeValue instanceof MessageFlowNode) || !StringUtils.equals((String)val, (String)(name = this.getName(toCompareNode = (MessageFlowNode)flowNodeValue))) || entityProcessed.contains(toCompareNode.getEntityId())) continue;
                entityProcessed.add(toCompareNode.getEntityId());
                if (++count <= 1) continue;
                return NAME_MUST_BE_UNIQUE;
            }
        }
        if (StringUtils.isNotBlank((String)(error = this.checkFlowNamesAreUnique(context, node, val, count)))) {
            return error;
        }
        boolean bl = springBeanId = node != null && "http://www.springframework.org/schema/beans/bean".equals(node.getType()) && editor.getHelper().getId().equals("id");
        if (springBeanId) {
            String id = value.toString();
            if (id.isEmpty()) {
                return null;
            }
            for (IMessageFlowEntity mfe : allGlobalEntries) {
                String id1;
                MessageFlowNode node1;
                if (!(mfe instanceof MessageFlowNode) || (node1 = (MessageFlowNode)mfe) == node || !"http://www.springframework.org/schema/beans/bean".equals(node1.getType()) || !(id1 = NameValidator.getId(node1)).equals(id)) continue;
                return ID_SHOULD_BE_UNIQUE;
            }
        } else {
            count = 0;
            for (IMessageFlowEntity mfe : allGlobalEntries) {
                String id1;
                MessageFlowNode node1;
                if (!(mfe instanceof MessageFlowNode) || (node1 = (MessageFlowNode)mfe) == node || !"http://www.springframework.org/schema/beans/bean".equals(node1.getType()) || !(id1 = NameValidator.getId(node1)).equals(value) || !StringUtils.isNotEmpty((String)id1) || !this.isNotUnique(node, ++count, null)) continue;
                return NAME_MUST_BE_UNIQUE;
            }
        }
        return null;
    }

    private String checkFlowNamesAreUnique(AttributeContext context, IMessageFlowNode node, String val, int count) {
        List flows = context.getFlows();
        for (Container flow : flows) {
            String name = this.getName((MessageFlowNode)flow);
            if (!name.equals(val) || !StringUtils.isNotEmpty((String)name) || !this.isNotUnique(node, ++count, (IMessageFlowNode)flow)) continue;
            return NAME_MUST_BE_UNIQUE;
        }
        return null;
    }

    protected String getName(MessageFlowNode node) {
        IReadOnlyPropertyCollection properties;
        String name = "";
        String nameAttributeName = MetadataHelpers.getNameAttributeName((IMessageFlowNode)node);
        if (nameAttributeName != null && (properties = node.getProperties()) != null) {
            IReadOnlyProperty nameProperty = (IReadOnlyProperty)properties.getProperty(nameAttributeName);
            name = nameProperty != null ? nameProperty.getValue() : "";
        }
        return name == null ? "" : name;
    }

    protected static String getId(MessageFlowNode node) {
        String propertyValue = PropertiesUtils.getPropertyValue((IPropertyCollectionReadCapability)node.getProperties(), (String)"id");
        if (propertyValue == null) {
            return "";
        }
        return propertyValue;
    }

    protected boolean isNotUnique(IMessageFlowNode node, int count, IMessageFlowNode value2) {
        return count > 1 || node != null && node != value2 && value2 != null && !this.compareIds(node, value2);
    }

    private boolean compareIds(IMessageFlowNode node, IMessageFlowNode value2) {
        boolean equals = node.getEntityId().equals(value2.getEntityId());
        if (!equals && value2.getEntityId().startsWith("!!!") && !node.getEntityId().startsWith("!!!")) {
            return true;
        }
        return equals;
    }
}

