/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import org.apache.commons.lang.StringUtils;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class JavaValidator
implements IValidator {
    protected String mustImplement;
    protected String mustExtend;

    public JavaValidator(String mustImplement, String mustExtend) {
        this.mustImplement = mustImplement;
        this.mustExtend = mustExtend;
    }

    @Override
    public String validate(Object value, AttributeContext context, AttributeHelper helper) {
        try {
            return this.doValidate(value, context);
        }
        catch (JavaModelException e) {
            return e.getMessage();
        }
    }

    private String doValidate(Object value, AttributeContext context) throws JavaModelException {
        String input = (String)value;
        if (StringUtils.isBlank((String)input) || this.isSpringProperty(input)) {
            return null;
        }
        IJavaProject prj = context.getProject().getJavaProject();
        IType findType = prj.findType(value.toString());
        if (findType == null) {
            return "Unable to find type '" + String.valueOf(value) + "' on build path of project " + prj.getElementName();
        }
        if (input.equals(this.mustImplement)) {
            return null;
        }
        if (input.equals(this.mustExtend)) {
            return null;
        }
        if (StringUtils.isNotBlank((String)this.mustImplement) && !this.inputImplementsInterface(findType, this.mustImplement)) {
            return "Type '" + String.valueOf(value) + "' does not implements " + this.mustImplement;
        }
        if (StringUtils.isNotBlank((String)this.mustExtend) && !this.inputExtendsClass(findType, this.mustExtend)) {
            return "Type '" + String.valueOf(value) + "' does not extends " + this.mustExtend;
        }
        return null;
    }

    private boolean inputExtendsClass(IType input, String mustExtend) throws JavaModelException {
        IType[] superClasses;
        IType[] iTypeArray = superClasses = input.newSupertypeHierarchy(null).getAllSuperclasses(input);
        int n = superClasses.length;
        int n2 = 0;
        while (n2 < n) {
            IType superClass = iTypeArray[n2];
            if (superClass.getFullyQualifiedName().equals(mustExtend)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean inputImplementsInterface(IType input, String mustImplement) throws JavaModelException {
        IType[] superInterfaces;
        IType[] iTypeArray = superInterfaces = input.newSupertypeHierarchy(null).getAllSuperInterfaces(input);
        int n = superInterfaces.length;
        int n2 = 0;
        while (n2 < n) {
            IType superInterface = iTypeArray[n2];
            if (superInterface.getFullyQualifiedName().equals(mustImplement)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean isSpringProperty(String value) {
        return value.startsWith("${") && value.endsWith("}");
    }
}

