/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.FilteredTypesSelectionDialog;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.mule.tooling.core.MuleCorePlugin;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IClassCreator;
import org.mule.tooling.ui.modules.core.widgets.IParametrizableFactory;
import org.mule.tooling.ui.modules.core.widgets.IValueFactory;
import org.mule.tooling.ui.modules.core.widgets.NewClassCreationWizard;

public class JavaFactory
implements IValueFactory,
IParametrizableFactory,
IClassCreator {
    private String atrName;
    private String assignableFrom;
    protected String mustExtend;
    protected String mustImplement;
    protected int searchType;

    public JavaFactory(String atrName, String mustImplement, String mustExtend, String assignableFrom, int searchType) {
        this.atrName = atrName;
        this.mustExtend = mustExtend;
        this.mustImplement = mustImplement;
        this.assignableFrom = assignableFrom;
        this.searchType = searchType;
    }

    @Override
    public Object getValue(AttributeContext context) {
        if (StringUtils.isNotBlank((String)this.mustImplement)) {
            return this.pickFromImplementors(context.getProject().getJavaProject());
        }
        if (StringUtils.isNotBlank((String)this.mustExtend)) {
            return this.pickFromSuperclass(context.getProject().getJavaProject());
        }
        if (StringUtils.isNotBlank((String)this.assignableFrom)) {
            return this.pickFromAssignableFrom(context.getProject().getJavaProject());
        }
        return this.pickClass(context.getProject().getJavaProject());
    }

    private Object pickFromSuperclass(IJavaProject project) {
        try {
            Object[] results;
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IType myInterface = project.findType(this.mustExtend);
            IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)myInterface);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)this.searchType, (boolean)false);
            if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                IType type = (IType)results[0];
                return type.getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unable to open classes dialog.", (IStatus)e.getStatus());
        }
        return null;
    }

    @Override
    public String getName() {
        return "Java Class";
    }

    protected Object pickClass(IJavaProject prj) {
        try {
            Object[] results;
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IProject project = prj.getProject();
            FilteredTypesSelectionDialog dialog = (FilteredTypesSelectionDialog)JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)context, (IProject)project, (int)this.searchType, (boolean)false);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    return Status.CANCEL_STATUS;
                }
            });
            dialog.setTitle(this.atrName + " browser");
            if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                IType type = (IType)results[0];
                return type;
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unable to open classes dialog.", (IStatus)e.getStatus());
        }
        return null;
    }

    private Shell getShell() {
        return Display.getCurrent().getActiveShell();
    }

    protected Object pickFromImplementors(IJavaProject project) {
        try {
            Object[] results;
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IType myInterface = project.findType(this.mustImplement);
            IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)myInterface);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)this.searchType, (boolean)false);
            if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                IType type = (IType)results[0];
                return type.getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unable to open classes dialog.", (IStatus)e.getStatus());
        }
        return null;
    }

    protected Object pickFromAssignableFrom(IJavaProject project) {
        try {
            Object[] results;
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IType myInterface = project.findType(this.assignableFrom);
            IJavaSearchScope scope = SearchEngine.createHierarchyScope((IType)myInterface);
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)context, (IJavaSearchScope)scope, (int)this.searchType, (boolean)false);
            dialog.setTitle("Search elements assignable from " + this.assignableFrom);
            if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                IType type = (IType)results[0];
                return type.getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unable to open classes dialog.", (IStatus)e.getStatus());
        }
        return null;
    }

    @Override
    public Object getValue(AttributeContext ct, String title, String message) {
        try {
            Object[] results;
            IWorkbenchWindow context = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
            IProject project = ct.getProject().getProject();
            FilteredTypesSelectionDialog dialog = (FilteredTypesSelectionDialog)JavaUI.createTypeDialog((Shell)this.getShell(), (IRunnableContext)context, (IProject)project, (int)this.searchType, (boolean)false);
            dialog.setValidator(new ISelectionStatusValidator(){

                public IStatus validate(Object[] selection) {
                    return Status.CANCEL_STATUS;
                }
            });
            dialog.setTitle(title);
            if (dialog.open() == 0 && (results = dialog.getResult()).length == 1) {
                IType type = (IType)results[0];
                return type.getFullyQualifiedName();
            }
        }
        catch (JavaModelException e) {
            ErrorDialog.openError((Shell)this.getShell(), (String)"Error", (String)"Unable to open classes dialog.", (IStatus)e.getStatus());
        }
        return null;
    }

    @Override
    public IType getCreatedClass(IProject project) {
        NewClassCreationWizard newClassWizard = new NewClassCreationWizard();
        NewClassWizardPage newClassWizardPage = (NewClassWizardPage)newClassWizard.getStartingPage();
        newClassWizardPage.init((IStructuredSelection)new StructuredSelection((Object)project.getFolder("src/main/java")));
        newClassWizardPage.setSuperClass(this.mustExtend, true);
        ArrayList<String> interfacesNames = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)this.mustImplement)) {
            interfacesNames.add(this.mustImplement);
        }
        if (StringUtils.isNotBlank((String)this.assignableFrom)) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            try {
                IType myType = javaProject.findType(this.assignableFrom);
                if (myType.isInterface()) {
                    interfacesNames.add(this.assignableFrom);
                } else {
                    newClassWizardPage.setSuperClass(this.assignableFrom, true);
                }
            }
            catch (JavaModelException e) {
                MuleCorePlugin.logError((String)"Unexpected error retriving created class", (Throwable)e);
            }
        }
        newClassWizardPage.setSuperInterfaces(interfacesNames, true);
        WizardDialog newClassWizardDialog = new WizardDialog(this.getShell(), (IWizard)newClassWizard);
        if (newClassWizardDialog.open() == 0) {
            return newClassWizardPage.getCreatedType();
        }
        return null;
    }
}

