/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import java.util.Optional;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValueFactory;

public class FileFactory
implements IValueFactory {
    private final Optional<String[]> extensions;

    public FileFactory() {
        this.extensions = Optional.empty();
    }

    public FileFactory(String[] extensions) {
        this.extensions = Optional.ofNullable(extensions);
    }

    @Override
    public Object getValue(AttributeContext context) {
        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
        IMuleProject project = context.getProject();
        if (project != null) {
            String fullPath = CoreUtils.getProjectRootFile((IMuleProject)project).getAbsolutePath();
            dialog.setFilterPath(fullPath);
        }
        this.extensions.ifPresent(arg_0 -> ((FileDialog)dialog).setFilterExtensions(arg_0));
        return dialog.open();
    }

    @Override
    public String getName() {
        return "File chooser";
    }
}

