/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import java.util.ArrayList;
import java.util.List;
import org.mule.tooling.core.model.IMuleProject;
import org.mule.tooling.core.utils.ExpressionUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.MuleConfiguration;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IValidator;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.meta.EnumOption;

public class DefaultErrorHandlerValidator
implements IValidator {
    public static final String NAME_NOT_VALID = "Value should be a system property or one of the following: ";

    @Override
    public String validate(Object value, AttributeContext context, AttributeHelper helper) {
        IMuleProject muleProject = context.getProject();
        if (muleProject != null) {
            List configurations = muleProject.getConfigurationsCache().getConfigurations();
            PossibleValues values = this.calcPossibleValues(configurations);
            int i = 0;
            while (i < values.getErrorHandlers().size()) {
                if (values.getErrorHandlers().get((int)i).value.equals(value.toString())) {
                    return null;
                }
                ++i;
            }
            if (ExpressionUtils.isPropertyPlaceholder((String)value.toString())) {
                return null;
            }
            if (!values.getErrorHandlers().isEmpty()) {
                return values.getPossibleValuesDescription().substring(0, values.getPossibleValuesDescription().length() - 1);
            }
            return values.getPossibleValuesDescription().toString();
        }
        return null;
    }

    public PossibleValues calcPossibleValues(List<MuleConfiguration> configurations) {
        ArrayList<EnumOption> errorHandlers = new ArrayList<EnumOption>();
        StringBuilder possibleValuesDescription = new StringBuilder(NAME_NOT_VALID);
        for (MuleConfiguration muleConfiguration : configurations) {
            List flows = muleConfiguration.getFlows();
            for (Container container : flows) {
                if (!"http://www.mulesoft.org/schema/mule/core/default-error-handler".equals(container.getType())) continue;
                errorHandlers.add(new EnumOption(container.getName()));
                possibleValuesDescription.append(container.getName()).append(",");
            }
        }
        return new PossibleValues(errorHandlers, possibleValuesDescription);
    }

    public class PossibleValues {
        private List<EnumOption> errorHandlers;
        private StringBuilder possibleValuesDescription;

        public PossibleValues(List<EnumOption> errorHandlers, StringBuilder possibleValuesDescription) {
            this.errorHandlers = errorHandlers;
            this.possibleValuesDescription = possibleValuesDescription;
        }

        public List<EnumOption> getErrorHandlers() {
            return this.errorHandlers;
        }

        public StringBuilder getPossibleValuesDescription() {
            return this.possibleValuesDescription;
        }
    }
}

