/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.core.utils.CoreUtils;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.model.messageflow.NestedContainer;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.utils.BatchNameValidator;

public class BatchStepNameValidator
extends BatchNameValidator {
    @Override
    Optional<String> doValidate(IMessageFlowNode node, String val, List<Container> allFlows) {
        if (!this.isBatchNameUnique(allFlows, val, node)) {
            return Optional.of("Name must be unique");
        }
        return Optional.empty();
    }

    @Override
    boolean isBatchNameUnique(List<Container> allFlows, String val, IMessageFlowNode node) {
        for (Container batchJob : this.getBatchJobs(allFlows)) {
            int count = 0;
            NestedContainer nestedContainer = batchJob.getNestedContainer("http://www.mulesoft.org/schema/mule/batch/process-records");
            if (nestedContainer == null) continue;
            List compartmentLaneEntries = nestedContainer.getCompartmentLaneEntries();
            for (Container container : CoreUtils.filterByType((Iterable)compartmentLaneEntries, Container.class)) {
                if (!this.isBatchStep(container) || !this.getName((MessageFlowNode)container).equals(val) || ++count <= 1) continue;
                return false;
            }
        }
        return true;
    }

    private boolean isBatchStep(Container container) {
        return container.getType().equals("http://www.mulesoft.org/schema/mule/batch/step");
    }

    @Override
    List<Container> getFlowsToValidate(AttributeContext context) {
        return context.getMuleConfiguration().getFlows();
    }
}

