/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.mule.tooling.model.messageflow.CompartmentLane;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowEntity;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;
import org.mule.tooling.ui.modules.core.widgets.utils.NameValidator;

public abstract class BatchNameValidator
extends NameValidator {
    public static final String NAME_REGEX = "[A-Za-z]+[A-Za-z0-9_\\.:-]*";
    public static final String NAME_MUST_BE_UNIQUE = "Name must be unique";
    public static final String NAME_MUST_BE_IDENT = "Name must be an identifier";
    public static final String NAME_MUST_NOT_BE_EMPTY = "Name must not be empty";

    @Override
    public String validate(Object value, AttributeContext context, AttributeHelper helper) {
        return this.validate(value, context, null, null);
    }

    @Override
    public String validate(Object value, AttributeContext context, IMessageFlowNode node, IFieldEditor editor) {
        List<Container> allFlows;
        Optional<String> result;
        String val = value.toString();
        if (val.length() > 0 && !val.matches(NAME_REGEX)) {
            return NAME_MUST_BE_IDENT;
        }
        if (editor != null && editor.getHelper() != null && val.length() == 0) {
            return editor.getHelper().isRequired() ? NAME_MUST_NOT_BE_EMPTY : null;
        }
        if (context != null && (result = this.doValidate(node, val, allFlows = this.getFlowsToValidate(context))).isPresent()) {
            return result.get();
        }
        return null;
    }

    protected List<Container> getBatchJobs(List<Container> flows) {
        ArrayList batchJobs = Lists.newArrayList();
        for (Container flow : flows) {
            for (CompartmentLane lane : flow.getLanes()) {
                for (IMessageFlowEntity entry : lane.getCompartmentLaneEntries()) {
                    Container batch;
                    if (!(entry instanceof Container) || !(batch = (Container)entry).getType().equals("http://www.mulesoft.org/schema/mule/batch/job")) continue;
                    batchJobs.add(batch);
                }
            }
        }
        return batchJobs;
    }

    abstract boolean isBatchNameUnique(List<Container> var1, String var2, IMessageFlowNode var3);

    abstract List<Container> getFlowsToValidate(AttributeContext var1);

    abstract Optional<String> doValidate(IMessageFlowNode var1, String var2, List<Container> var3);
}

