/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import java.util.List;
import java.util.Optional;
import org.mule.tooling.model.messageflow.Container;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.MessageFlowNode;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.utils.BatchNameValidator;

public class BatchJobNameValidator
extends BatchNameValidator {
    @Override
    Optional<String> doValidate(IMessageFlowNode node, String val, List<Container> allFlows) {
        if (!this.isBatchNameUnique(allFlows, val, node)) {
            return Optional.of("Name must be unique");
        }
        return Optional.empty();
    }

    @Override
    boolean isBatchNameUnique(List<Container> allFlows, String val, IMessageFlowNode node) {
        int count = 0;
        for (Container batchJob : this.getBatchJobs(allFlows)) {
            String jobName = this.getName((MessageFlowNode)batchJob);
            if (val.equals(jobName)) {
                ++count;
            }
            if (count <= 1) continue;
            return false;
        }
        return true;
    }

    @Override
    List<Container> getFlowsToValidate(AttributeContext context) {
        return context.getFlows();
    }
}

