/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tooling.ui.modules.core.widgets.utils;

import java.text.MessageFormat;
import java.util.List;
import org.mule.tooling.model.messageflow.IMessageFlowNode;
import org.mule.tooling.model.messageflow.IPropertyCollectionReadCapability;
import org.mule.tooling.model.messageflow.IReadOnlyProperty;
import org.mule.tooling.model.messageflow.IReadOnlyPropertyCollection;
import org.mule.tooling.model.messageflow.PropertyCollection;
import org.mule.tooling.ui.modules.core.widgets.AttributeContext;
import org.mule.tooling.ui.modules.core.widgets.IEntityAwareValidator;
import org.mule.tooling.ui.modules.core.widgets.IFieldEditor;
import org.mule.tooling.ui.modules.core.widgets.editors.ChildElementEditStack;
import org.mule.tooling.ui.modules.core.widgets.meta.AttributeHelper;

public class BatchHistoryValidator
implements IEntityAwareValidator {
    private static final String ERROR_MESSAGE_FORMAT = "Both {0} and {1} must be configured";

    @Override
    public String validate(Object value, AttributeContext context, AttributeHelper helper) {
        return null;
    }

    @Override
    public String validate(Object value, AttributeContext context, IMessageFlowNode node, IFieldEditor editor) {
        String message = null;
        ChildElementEditStack.ListInfo currentElement = ChildElementEditStack.current();
        if (currentElement != null) {
            List<PropertyCollection> childElementPropertyCollections = currentElement.currentElements;
            message = this.doValidate(childElementPropertyCollections);
        } else {
            List propertyCollections = node.getProperties().getPropertyCollections();
            for (IReadOnlyPropertyCollection propertyCollection : propertyCollections) {
                List grandChildrenPropertyCollections = propertyCollection.getPropertyCollections();
                message = this.doValidate(grandChildrenPropertyCollections);
            }
        }
        return message;
    }

    private <PC, P extends IReadOnlyProperty> String doValidate(List<? extends IPropertyCollectionReadCapability<PC, P>> childElementPropertyCollections) {
        for (IPropertyCollectionReadCapability<PC, P> propertyCollection : childElementPropertyCollections) {
            IReadOnlyProperty maxAgeProperty = (IReadOnlyProperty)propertyCollection.getProperty("maxAge");
            IReadOnlyProperty ageUnitProperty = (IReadOnlyProperty)propertyCollection.getProperty("ageUnit");
            if (!(this.hasValue(maxAgeProperty) ^ this.hasValue(ageUnitProperty))) continue;
            return MessageFormat.format(ERROR_MESSAGE_FORMAT, "maxAge", "ageUnit");
        }
        return null;
    }

    private boolean hasValue(IReadOnlyProperty property) {
        return property != null && property.getValue() != null && !property.getValue().isEmpty();
    }
}

